<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class CollateralDetail extends Model
{
    use SoftDeletes, LogsActivity;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id','title','client_id','loan_id','status','collateral_id','number','body_number','number_plate',
        'model_type','color','engine_number','cylinder_size','degree','year','date_made','price_market','price_urgent',
        'head_land','size','issued_by','location','status_type','north','south','east','west'
    ];
    protected $logAttributes = [
        'id','title','client_id','loan_id','status','collateral_id','number','body_number','number_plate',
        'model_type','color','engine_number','cylinder_size','degree','year','date_made','price_market','price_urgent',
        'head_land','size','issued_by','location','status_type','north','south','east','west'
    ];
    public function userAttachment()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Collateral Detail Model';
    protected static $logOnlyDirty = true;

    public function getDescriptionForEvent(string $eventName): string
    {
        return "This user has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->branch_id = Auth::user()->branch_id;
        $activity->agent = request()->header('user-agent');
    }
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id');
    }
    public function collateral()
    {
        return $this->belongsTo(Collateral::class, 'collateral_id');
    }

}
