<?php

namespace App\Models;

use App\Models\Department;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Company extends Model
{
    use HasFactory, Notifiable,SoftDeletes, LogsActivity;
    protected $fillable = [
        'code', 'name_en', 'name_kh', 'contact_number','email','website','address','logo','status',
    ];
    
    protected static $logAttributes = [
        'code', 'name_en', 'name_kh', 'contact_number','email','website','address','logo','status',
    ];

    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Company Model';
    protected static $logOnlyDirty = true;

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->agent = request()->header('user-agent');
    }

    public function scopeSearch($query, $searchText)
    {
        if(isset($searchText)){
            $query->where("code","LIKE","$searchText%");
            $query->orWhere("name_en","LIKE","$searchText%");
            $query->orWhere("name_kh","LIKE","$searchText%");
            $query->orWhere("contact_number","LIKE","$searchText%");
        }
        return $query;
    }

    public function department()
    {
        return $this->hasMany(Department::class,'company_id');
    }
}
