<?php

namespace App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Group extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'groups';
    protected $fillable = [
        'user_id',
        'co_id',
        'status',
        'id',
    ];

    protected static $logAttributes = [
        'user_id',
        'co_id',
        'status',
        'id',
    ];

    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'Group Model';
    protected static $logOnlyDirty = true;
    public function getDescriptionForEvent(string $eventName): string
    {
        return "This Group has been {$eventName}";
    }
    public function CO()
    {
        return $this->belongsTo(User::class, 'co_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
