<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
use Spatie\Activitylog\Traits\LogsActivity;

class Loan extends Model
{
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id','client_id','co_id', 'branch_id', 'currency_id', 'completed_date', 'installment_date', 'start_date', 'reschedule_amount','balance_maintenance',
        'loan_code','loan_out','interest', 'total_interest', 'risk', 'total_risk', 'service','total_service', 'service_collection','total_collection', 'loan_receive', 'balance_principal',
        'balance_interest','balance_risk', 'loan_balance', 'paid_principal', 'paid_interest','paid_risk', 'loan_in','total_penalty','paid_maintenance' ,'desc' ,'client_type',
        'term_type','period', 'condition_pay','loan_status_id','closing_date','approved_by','closing_by','type_loan', 'maintenance','total_maintenance','saving','total_saving','total_waiv'
    ];

    public function currency()
    {
        return $this->belongsTo(Loan::class, 'currency_id');
    }
    public function loan_status()
    {
        return $this->belongsTo(LoanStatus::class, 'loan_status_id');
    }
    public function co()
    {
        return $this->belongsTo(User::class, 'co_id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
    public function getsumprincipalAttribute()
    {
        return $this->where('co_id',$this->co_id)->sum('loan_out');
    }
    public function getsuminterestAttribute()
    {
        return $this->where('co_id',$this->co_id)->sum('total_interest');
    }
    public function getsumriskAttribute()
    {
        return $this->where('co_id',$this->co_id)->sum('total_risk');
    }

    public function gettotalBalanceprincipalAttribute()
    {
        // $reschedule=  Loan::where('id', $this->id)->where(function($query) {
        //         $query->whereIn('branch_id',Helper::byBranch());
        //         $query->where('currency_id',Helper::byCurrency());
        //         $query->where('loan_status_id',2);
        //     })
        //     ->whereHas('co', function ($query) {
        //         $query->where('status',1);
        //     })
        //     ->whereHas('client', function ($query) {
        //         $query->where('status',1);
        //     })
        //     ->sum('reschedule_amount');
        //     $principal=  Loan::where('id', $this->id)->where(function($query)  {
        //         $query->whereIn('branch_id',Helper::byBranch());
        //         $query->where('currency_id',Helper::byCurrency());
        //         $query->where('loan_status_id',2);
        //     })
        //     ->whereHas('co', function ($query) {
        //         $query->where('status',1);
        //     })
        //     ->whereHas('client', function ($query) {
        //         $query->where('status',1);
        //     })
        //     ->sum('loan_out');

        //     $paid_principal = AccReceivableDetails::where('loan_id',$this->id)->whereHas('loan', function($q){
        //             $q->where('loan_status_id',2);
        //         })
        //         ->where(function($query) {
        //             $query->whereIn('branch_id',Helper::byBranch());
        //             $query->where('currency_id',Helper::byCurrency());
        //         })
        //         ->whereHas('co', function ($query) {
        //             $query->where('status',1);
        //         })
        //         ->whereHas('client', function ($query) {
        //             $query->where('status',1);
        //         })
        //         ->sum('paid_principal');

        //     $total= ($reschedule+$principal)-$paid_principal;

        //     return $total;

        $branches = Helper::byBranch();
        $currencies = Helper::byCurrency();

        $loan = Loan::selectRaw('SUM(reschedule_amount) as total_reschedule, SUM(loan_out) as total_out')
            ->where('id', $this->id)
            ->whereIn('branch_id', $branches)
            ->where('currency_id', $currencies)
            ->where('loan_status_id', 2)
            ->whereHas('co', fn($q) => $q->where('status', 1))
            ->whereHas('client', fn($q) => $q->where('status', 1))
            ->first();

        $paid_principal = AccReceivableDetails::where('loan_id', $this->id)
            ->whereHas('loan', function($q) use ($branches, $currencies) {
                $q->where('loan_status_id', 2)
                ->whereIn('branch_id', $branches)
                ->where('currency_id', $currencies)
                ->whereHas('co', fn($q) => $q->where('status', 1))
                ->whereHas('client', fn($q) => $q->where('status', 1));
            })
            ->sum('paid_principal');

        return (($loan->total_reschedule ?? 0) + ($loan->total_out ?? 0)) - $paid_principal;
    }
    public function getcountdaylateAttribute()
    {
        $late = AccReceivables::where('co_id',$this->co_id)
                ->where('payment_date','<',date('Y-m-d'))->whereIn('payment_status_id',[2,3])->groupBy('client_id')->get()->count();
        $amount = AccReceivables::where('co_id',$this->co_id)
                ->where('payment_date','<',date('Y-m-d'))->whereIn('payment_status_id',[2,3])->sum('principal');
        return array(
            'late' => $late,
            'amount' => $amount
        );
    }
}
