<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LogActivity extends Model
{
    protected $table = 'activity_log';
    protected $fillable = [
        'subject_type', 'subject_id', 'branch_id', 'ip', 'agent', 'causer_type', 'causer_id', 'description', 'properties','log_name'
    ];
    public function user()
    {
        return $this->belongsTo(User::class, 'causer_id');
    }
}
