<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class PaymentMethod extends Model
{
    use SoftDeletes, LogsActivity;
    protected $table = 'payment_methods';
    protected $fillable = [
        'title','des'
    ];
    protected static $logAttributes = [
        'title','des'
    ];
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'paymentMethod Model';
    protected static $logOnlyDirty = true;
    public function getDescriptionForEvent(string $eventName): string
    {
        return "This payment method has been {$eventName}";
    }
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->agent = request()->header('user-agent');
    }
}
