<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Province extends Model
{
    protected $table = 'provinces';
    protected $fillable =[
        'id','name_km','full_name_km','address_km',
    ];
    public function scopeSearch($query, $searchText)
    {
        if(isset($searchText)){
            $query->where("address_km","LIKE","%$searchText%");
        }
        return $query;
    }
}
