<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Permission\Traits\HasRoles;

class Saving extends Model
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles, SoftDeletes, LogsActivity;
    protected $table = 'savings';
    protected $fillable =[
        'id','client_id','co_id','loan_id','percent','amount', 'status', 'closing_date','status_pay','date_approved','closing_by', 'branch_id','currency_id'
    ];
    protected static $logAttributes = [
        'id','client_id','co_id','loan_id','percent','amount', 'status', 'closing_date','status_pay','date_approved','closing_by', 'branch_id','currency_id'
    ];
    public function userAttachment()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'User Model';
    protected static $logOnlyDirty = true;

    public function getDescriptionForEvent(string $eventName): string
    {
        return "This user has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->agent = request()->header('user-agent');
    }

    public function scopeSearch($query, $searchText)
    {
        if (isset($searchText)) {
            $query->name($searchText);
            $query->orWhere(function($q) use($searchText){
                $q->email($searchText);
            });
            $query->orWhere(function($q) use($searchText){
                $q->phone($searchText);
            });
            $query->orWhereHas("roles", function ($q) use ($searchText) {
                $q->where("name", "LIKE", "%$searchText%");
            });
            $query->orWhereHas("position", function ($q) use ($searchText) {
                $q->where("name", "LIKE", "%$searchText%");
            });
        }
        return $query;
    }
    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id');
    }
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
    public function co()
    {
        return $this->belongsTo(User::class, 'co_id');
    }

}
