<?php

namespace App\Models;

use App\Helpers\CustomDateFilter;
use App\Helpers\Helper;
use App\Models\UserAttachment;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Models\Permission;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\DB;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles, SoftDeletes, LogsActivity;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name','code', 'branch_id','currency_id', 'nickname', 'gender', 'email', 'password', 'contact_number',
        'photo', 'attach_file', 'status','last_seen', 'address', 'type','date_start_working',
        'type_document', 'id_card', 'place_of_birth','date_of_birth', 'create_card_date', 'expired_card_date',
        'work_place', 'institution', 'position', 'province_id','district_id', 'commune_id', 'village_id'
    ];

    protected static $logAttributes = [
        'name','code', 'branch_id','currency_id', 'nickname', 'gender', 'email', 'password', 'contact_number',
        'photo', 'attach_file', 'status','last_seen', 'address', 'type',
        'type_document', 'id_card', 'place_of_birth','date_of_birth', 'create_card_date', 'expired_card_date',
        'work_place', 'institution', 'position', 'province_id','district_id', 'commune_id', 'village_id'
    ];


    public function userAttachment()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }
    protected static $recordEvents = ['deleted', 'created', 'updated'];
    protected static $logName = 'User Model';
    protected static $logOnlyDirty = true;

    public function getDescriptionForEvent(string $eventName): string
    {
        return "This user has been {$eventName}";
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->ip = request()->ip();
        $activity->agent = request()->header('user-agent');
    }

    public function scopeSearch($query, $searchText)
    {
        if (isset($searchText)) {
            $query->name($searchText);
            $query->orWhere(function($q) use($searchText){
                $q->email($searchText);
            });
            $query->orWhere(function($q) use($searchText){
                $q->phone($searchText);
            });
            $query->orWhereHas("roles", function ($q) use ($searchText) {
                $q->where("name", "LIKE", "%$searchText%");
            });
            $query->orWhereHas("position", function ($q) use ($searchText) {
                $q->where("name", "LIKE", "%$searchText%");
            });
        }
        return $query;
    }
    public function loan()
    {
        return $this->hasMany(Loan::class, 'co_id','id');
    }
    public function village()
    {
        return $this->belongsTo(Village::class, 'village_id');
    }
    public function commune()
    {
        return $this->belongsTo(Commune::class, 'commune_id');
    }
    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }
    public function province()
    {
        return $this->belongsTo(Province::class, 'province_id');
    }
    public function getsumprincipalsAttribute()
    {
        return Loan::where('co_id',$this->id)
        ->where(function($query){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->where('loan_status_id',2);
            if(!request()->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), request()->date);
            }
            if(!request()->client_id ==[]){
                $query->whereIn('client_id',request()->client_id);
            }
            if(!request()->co_id ==[])
            {
                $query->whereIn('co_id',request()->co_id);
            }
        })
        ->whereHas('co', function ($query) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) {
            $query->where('status',1);
        })
        ->sum('loan_out');
    }
    public function getsuminterestsAttribute()
    {
        return Loan::where('co_id',$this->id)
        ->where(function($query){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->where('loan_status_id',2);
            if(!request()->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), request()->date);
            }
            if(!request()->client_id ==[]){
                $query->whereIn('client_id',request()->client_id);
            }
            if(!request()->co_id ==[])
            {
                $query->whereIn('co_id',request()->co_id);
            }
        })
        ->whereHas('co', function ($query) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) {
            $query->where('status',1);
        })
        ->sum('total_interest');
    }
    public function getsumrisksAttribute()
    {
        return Loan::where('co_id',$this->id)
        ->where(function($query){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->where('loan_status_id',2);
            if(!request()->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), request()->date);
            }
            if(!request()->client_id ==[]){
                $query->whereIn('client_id',request()->client_id);
            }
            if(!request()->co_id ==[])
            {
                $query->whereIn('co_id',request()->co_id);
            }
        })
        ->whereHas('co', function ($query) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) {
            $query->where('status',1);
        })
        ->sum('total_risk');
    }
    public function getsummaintenancesAttribute()
    {
        return Loan::where('co_id',$this->id)
        ->where(function($query){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->where('loan_status_id',2);
            if(!request()->date==[])
            {
                $query->whereBetween(DB::raw("DATE_FORMAT(installment_date, '%Y-%m-%d')"), request()->date);
            }
            if(!request()->client_id ==[]){
                $query->whereIn('client_id',request()->client_id);
            }
            if(!request()->co_id ==[])
            {
                $query->whereIn('co_id',request()->co_id);
            }
        })
        ->whereHas('co', function ($query) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) {
            $query->where('status',1);
        })
        ->sum('total_maintenance');
    }

    // public function sumAmountPaid(){
    //     // $branches = Helper::byBranch();
    //     $currencies = Helper::byCurrency();

    //     $data = AccReceivableDetails::select(
    //         'paid_principal',
    //         'paid_interest',
    //         'paid_risk',
    //         'paid_maintenance',
    //         )
    //     // selectRaw('SUM(paid_principal), SUM(paid_interest), SUM(paid_risk), SUM(paid_maintenance)')

    //     ->where('co_id', $this->id)
    //     // ->whereIn('branch_id', $branches)
    //     ->where('currency_id', $currencies)
    //     ->whereHas('co', fn($q) => $q->where('status', 1))
    //     ->whereHas('client', fn($q) => $q->where('status', 1))
    //     ->when(request()->date,function($query){
    //         $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
    //     })
    //     ->when(request()->client_id,function($query){
    //         $query->whereIn('client_id',request()->client_id);
    //     })
    //     ->when(request()->co_id,function($query){
    //         $query->whereIn('co_id',request()->co_id);
    //     });
    //     return $data;
    // }
    // public function getpaidprincipalAttribute()
    // {
    //     return $this->sumAmountPaid()->sum('paid_principal');
    //     // $branches = Helper::byBranch();
    //     // $currencies = Helper::byCurrency();

    //     // return AccReceivableDetails::where('co_id', $this->id)
    //     // ->whereIn('branch_id', $branches)
    //     // ->where('currency_id', $currencies)
    //     // ->whereHas('co', fn($q) => $q->where('status', 1))
    //     // ->whereHas('client', fn($q) => $q->where('status', 1))
    //     // ->when(request()->date,function($query){
    //     //     $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
    //     // })
    //     // ->when(request()->client_id,function($query){
    //     //     $query->whereIn('client_id',request()->client_id);
    //     // })
    //     // ->when(request()->co_id,function($query){
    //     //     $query->whereIn('co_id',request()->co_id);
    //     // })
    //     // ->sum('paid_principal');


    //     // return AccReceivableDetails::where('co_id',$this->id)
    //     // ->where(function($query){
    //     //     $query->whereIn('branch_id',Helper::byBranch());
    //     //     $query->where('currency_id',Helper::byCurrency());
    //     //     if(!request()->date==[])
    //     //     {
    //     //         $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
    //     //     }
    //     //     if(!request()->client_id ==[]){
    //     //         $query->whereIn('client_id',request()->client_id);
    //     //     }
    //     //     if(!request()->co_id ==[])
    //     //     {
    //     //         $query->whereIn('co_id',request()->co_id);
    //     //     }
    //     // })
    //     // ->whereHas('co', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->whereHas('client', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->sum('paid_principal');




    // }
    // public function getpaidinterestAttribute()
    // {
    //     return $this->sumAmountPaid()->sum('paid_interest');
    //     // return AccReceivableDetails::where('co_id',$this->id)
    //     // ->where(function($query){
    //     //     $query->whereIn('branch_id',Helper::byBranch());
    //     //     $query->where('currency_id',Helper::byCurrency());
    //     //     if(!request()->date==[])
    //     //     {
    //     //         $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
    //     //     }
    //     //     if(!request()->client_id ==[]){
    //     //         $query->whereIn('client_id',request()->client_id);
    //     //     }
    //     //     if(!request()->co_id ==[])
    //     //     {
    //     //         $query->whereIn('co_id',request()->co_id);
    //     //     }
    //     // })
    //     // ->whereHas('co', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->whereHas('client', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->sum('paid_interest');
    // }
    // public function getpaidriskAttribute()
    // {
    //     return $this->sumAmountPaid()->sum('paid_risk');
    //     // return AccReceivableDetails::where('co_id',$this->id)
    //     // ->where(function($query){
    //     //     $query->whereIn('branch_id',Helper::byBranch());
    //     //     $query->where('currency_id',Helper::byCurrency());
    //     //     if(!request()->date==[])
    //     //     {
    //     //         $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
    //     //     }
    //     //     if(!request()->client_id ==[]){
    //     //         $query->whereIn('client_id',request()->client_id);
    //     //     }
    //     //     if(!request()->co_id ==[])
    //     //     {
    //     //         $query->whereIn('co_id',request()->co_id);
    //     //     }
    //     // })
    //     // ->whereHas('co', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->whereHas('client', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->sum('paid_risk');
    // }
    // public function getpaidmaintenanceAttribute()
    // {
    //     return $this->sumAmountPaid()->sum('paid_maintenance');

    //     // return AccReceivableDetails::where('co_id',$this->id)
    //     // ->where(function($query){
    //     //     $query->whereIn('branch_id',Helper::byBranch());
    //     //     $query->where('currency_id',Helper::byCurrency());
    //     //     if(!request()->date==[])
    //     //     {
    //     //         $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
    //     //     }
    //     //     if(!request()->client_id ==[]){
    //     //         $query->whereIn('client_id',request()->client_id);
    //     //     }
    //     //     if(!request()->co_id ==[])
    //     //     {
    //     //         $query->whereIn('co_id',request()->co_id);
    //     //     }
    //     // })
    //     //  ->whereHas('co', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->whereHas('client', function ($query) {
    //     //     $query->where('status',1);
    //     // })
    //     // ->sum('paid_maintenance');
    // }
    // public function getbalanceprincipalAttribute()
    // {
    //     $month = empty(request()->month)?null:date('Y-m',strtotime(request()->month));
    //     // $reschedule=  Loan::where('co_id',$this->id)
    //     //     ->where(function($query) use($month){
    //     //         $query->whereIn('branch_id',Helper::byBranch());
    //     //         $query->where('currency_id',Helper::byCurrency());
    //     //         $query->where('loan_status_id',2);
    //     //         if(!request()->month ==[]){
    //     //             $query->where(DB::raw("DATE_FORMAT(installment_date, '%Y-%m')"),'<=',$month);
    //     //         }
    //     //         if(!request()->client_id ==[]){
    //     //             $query->whereIn('client_id',request()->client_id);
    //     //         }
    //     //         if(!request()->co_id ==[])
    //     //         {
    //     //             $query->whereIn('co_id',request()->co_id);
    //     //         }
    //     //     })
    //     //     ->whereHas('co', function ($query) {
    //     //         $query->where('status',1);
    //     //     })
    //     //     ->whereHas('client', function ($query) {
    //     //         $query->where('status',1);
    //     //     })
    //     //     ->sum('reschedule_amount');
    //     //     $principal=  Loan::where('co_id',$this->id)
    //     //     ->where(function($query)  use($month){
    //     //         $query->whereIn('branch_id',Helper::byBranch());
    //     //         $query->where('currency_id',Helper::byCurrency());
    //     //         $query->where('loan_status_id',2);
    //     //         if(!request()->month ==[]){
    //     //             $query->where(DB::raw("DATE_FORMAT(installment_date, '%Y-%m')"),'<=',$month);
    //     //         }
    //     //         if(!request()->client_id ==[]){
    //     //             $query->whereIn('client_id',request()->client_id);
    //     //         }
    //     //         if(!request()->co_id ==[])
    //     //         {
    //     //             $query->whereIn('co_id',request()->co_id);
    //     //         }
    //     //     })
    //     //     ->whereHas('co', function ($query) {
    //     //         $query->where('status',1);
    //     //     })
    //     //     ->whereHas('client', function ($query) {
    //     //         $query->where('status',1);
    //     //     })
    //     //     ->sum('loan_out');

    //     //     $paid_principal = AccReceivableDetails::where('co_id',$this->id)
    //     //         ->whereHas('loan', function($q){
    //     //             $q->where('loan_status_id',2);
    //     //         })
    //     //         ->where(function($query) use($month) {
    //     //             $query->whereIn('branch_id',Helper::byBranch());
    //     //             $query->where('currency_id',Helper::byCurrency());
    //     //             if(!request()->month ==[]){
    //     //                 $query->where(DB::raw("DATE_FORMAT(received_date, '%Y-%m')"),'<=',$month);
    //     //             }
    //     //             if(!request()->client_id ==[]){
    //     //                 $query->whereIn('client_id',request()->client_id);
    //     //             }
    //     //             if(!request()->co_id ==[])
    //     //             {
    //     //                 $query->whereIn('co_id',request()->co_id);
    //     //             }
    //     //         })
    //     //         ->whereHas('co', function ($query) {
    //     //             $query->where('status',1);
    //     //         })
    //     //         ->whereHas('client', function ($query) {
    //     //             $query->where('status',1);
    //     //         })
    //     //         ->sum('paid_principal');

    //     //     $total= ($reschedule+$principal)-$paid_principal;

    //     //     return $total;

    //     $month = empty(request()->month)?null:date('Y-m',strtotime(request()->month));
    //     $principal=  AccReceivables::whereHas('loan', function($query)  use($month){
    //         $query->whereIn('branch_id',Helper::byBranch());
    //         $query->where('currency_id',Helper::byCurrency());
    //         $query->where('loan_status_id',2);
    //         if(!request()->date ==[]){
    //             $query->where(DB::raw("DATE_FORMAT(installment_date, '%Y-%m')"),'<=',$month);
    //         }
    //         if(!request()->co_id ==[])
    //         {
    //             $query->whereIn('co_id',request()->co_id);
    //         }else{
    //             $query->where('co_id',$this->id);
    //         }
    //     })
    //     ->sum('principal');

    //    $paid_principal = AccReceivableDetails::where('co_id',$this->id)
    //          ->where(function($query) use($month) {
    //             $query->whereIn('branch_id',Helper::byBranch());
    //             $query->where('currency_id',Helper::byCurrency());
    //             if(!request()->date ==[]){
    //                 $query->where(DB::raw("DATE_FORMAT(received_date, '%Y-%m')"),'<=',$month);
    //             }
    //             if(!request()->co_id ==[])
    //             {
    //                 $query->whereIn('co_id',request()->co_id);
    //             }
    //         })
    //         ->whereHas('co', function ($query) {
    //             $query->where('status',1);
    //         })
    //         ->whereHas('loan', function ($query) {
    //             $query->where('loan_status_id',2);
    //         })
    //         ->whereHas('client', function ($query) {
    //             $query->where('status',1);
    //         })
    //         ->sum('paid_principal');

    //     $total= $principal-$paid_principal;

    //     return $total;

    // }

    // public function getbalanceinterestAttribute()
    // {
    //     return Loan::where('co_id',$this->id)
    //     ->where(function($query){
    //         $query->whereIn('branch_id',Helper::byBranch());
    //         $query->where('currency_id',Helper::byCurrency());
    //         if(!request()->client_id ==[]){
    //             $query->whereIn('client_id',request()->client_id);
    //         }
    //         if(!request()->co_id ==[])
    //         {
    //             $query->whereIn('co_id',request()->co_id);
    //         }
    //     })
    //     ->whereHas('co', function ($query) {
    //         $query->where('status',1);
    //     })
    //     ->whereHas('client', function ($query) {
    //         $query->where('status',1);
    //     })
    //     ->sum('balance_interest');
    // }
    // public function getbalanceriskAttribute()
    // {
    //     return Loan::where('co_id',$this->id)
    //     ->where(function($query){
    //         $query->whereIn('branch_id',Helper::byBranch());
    //         $query->where('currency_id',Helper::byCurrency());
    //         if(!request()->client_id ==[]){
    //             $query->whereIn('client_id',request()->client_id);
    //         }
    //         if(!request()->co_id ==[])
    //         {
    //             $query->whereIn('co_id',request()->co_id);
    //         }
    //     })
    //     ->whereHas('co', function ($query) {
    //         $query->where('status',1);
    //     })
    //     ->whereHas('client', function ($query) {
    //         $query->where('status',1);
    //     })
    //     ->sum('balance_risk');
    // }
    // public function getbalancemaintenanceAttribute()
    // {
    //     return Loan::where('co_id',$this->id)
    //     ->where(function($query){
    //         $query->whereIn('branch_id',Helper::byBranch());
    //         $query->where('currency_id',Helper::byCurrency());
    //         if(!request()->client_id ==[]){
    //             $query->whereIn('client_id',request()->client_id);
    //         }
    //         if(!request()->co_id ==[])
    //         {
    //             $query->whereIn('co_id',request()->co_id);
    //         }
    //     })
    //     ->whereHas('co', function ($query) {
    //         $query->where('status',1);
    //     })
    //     ->whereHas('client', function ($query) {
    //         $query->where('status',1);
    //     })
    //     ->sum('balance_maintenance');
    // }

     public function getClientActiveAttribute()
    {
        return Loan::where('co_id',$this->id)
        ->where(function($query){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            $query->where('loan_status_id',2);
            if(!request()->client_id ==[]){
                $query->whereIn('client_id',request()->client_id);
            }
            if(!request()->co_id ==[])
            {
                $query->whereIn('co_id',request()->co_id);
            }
        })
        ->whereHas('co', function ($query) {
            $query->where('status',1);
        })
        ->whereHas('client', function ($query) {
            $query->where('status',1);
        })
        ->count();
    }

    public function getcountdaylateAttribute()
    {
        // $late = AccReceivables::where('co_id',$this->id)
        // ->whereIn('branch_id',Helper::byBranch())
        // ->where('currency_id',Helper::byCurrency())
        // ->where('payment_date','<',date('Y-m-d'))
        // ->whereIn('payment_status_id',[2,3])
        // ->where(function ($query) {
        //     if(!request()->client_id ==[]){
        //         $query->whereIn('client_id',request()->client_id);
        //     }
        //     if(!request()->co_id ==[])
        //     {
        //         $query->whereIn('co_id',request()->co_id);
        //     }
        // })
        // ->whereHas('co', function ($query) {
        //     $query->where('status',1);
        // })
        // ->whereHas('client', function ($query) {
        //     $query->where('status',1);
        // })
        // ->groupBy('loan_id')->get()->count();

        // $amount = AccReceivables::where('co_id',$this->id)
        // ->whereIn('branch_id',Helper::byBranch())
        // ->where('currency_id',Helper::byCurrency())
        // ->where('payment_date','<',date('Y-m-d'))
        // ->whereIn('payment_status_id',[2,3])
        // ->where(function ($query) {
        //     if(!request()->client_id ==[]){
        //         $query->whereIn('client_id',request()->client_id);
        //     }
        //     if(!request()->co_id ==[])
        //     {
        //         $query->whereIn('co_id',request()->co_id);
        //     }
        // })
        // ->whereHas('co', function ($query) {
        //     $query->where('status',1);
        // })
        // ->whereHas('client', function ($query) {
        //     $query->where('status',1);
        // })
        // ->sum('principal');
        // return array(
        //     'late' => $late,
        //     'amount' => $amount,
        // );

         $baseQuery = AccReceivables::query()
            ->where('co_id', $this->id)
            ->whereIn('branch_id', Helper::byBranch())
            ->where('currency_id', Helper::byCurrency())
            ->where('payment_date', '<', now()->toDateString())
            ->whereIn('payment_status_id', [2, 3])
            ->when(request()->filled('client_id'), function ($query) {
                $query->whereIn('client_id', (array) request()->client_id);
            })
            ->when(request()->filled('co_id'), function ($query) {
                $query->whereIn('co_id', (array) request()->co_id);
            })
            ->whereHas('co', fn($q) => $q->where('status', 1))
            ->whereHas('client', fn($q) => $q->where('status', 1));

        return [
            'late'   => (clone $baseQuery)->groupBy('loan_id')->get()->count(),
            'amount' => (clone $baseQuery)->sum('principal'),
        ];
    }

//   public function getCountDayLateAttribute()
// {
//     $result = AccReceivables::query()
//         ->join('users', 'users.id', '=', 'acc_receivables.co_id')
//         ->join('clients', 'clients.id', '=', 'acc_receivables.client_id')
//         ->where('acc_receivables.co_id', $this->id)
//         ->whereIn('acc_receivables.branch_id', Helper::byBranch())
//         ->where('acc_receivables.currency_id', Helper::byCurrency())
//         ->where('acc_receivables.payment_date', '<', now()->toDateString())
//         ->whereIn('acc_receivables.payment_status_id', [2, 3])
//         ->where('users.status', 1)
//         ->where('clients.status', 1)
//         ->when(request()->filled('client_id'), function ($q) {
//             $q->whereIn('acc_receivables.client_id', (array) request()->client_id);
//         })
//         ->when(request()->filled('co_id'), function ($q) {
//             $q->whereIn('acc_receivables.co_id', (array) request()->co_id);
//         })
//         ->selectRaw('COUNT(DISTINCT acc_receivables.loan_id) AS total_late, COALESCE(SUM(acc_receivables.principal), 0) AS total_amount')
//         ->first();

//     return [
//         // 'late'   => (int) ($result->total_late ?? 0),
//         'late'   => (clone $result)->groupBy('loan_id')->get()->count(),
//         'amount' => (float) ($result->total_amount ?? 0),
//     ];
// }



    public function scopeName($query, $searchText)
    {
        $query->where("name", "LIKE", "%$searchText%");
    }
    public function scopeEmail($query, $searchText)
    {
        $query->where("email", "LIKE", "%$searchText%");
    }
    public function scopePhone($query, $searchText)
    {
        $query->where("contact_number", "LIKE", "%$searchText%");
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getAllPermissionsAttribute()
    {
        $permissions = [];
        foreach (Permission::all() as $permission) {
            if (Auth::user()->can($permission->name)) {
                $permissions[] = $permission->name;
            }
        }
        return $permissions;
    }
}
