<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class Village extends Model
{
    protected $table = 'villages';
    protected $fillable =[
        'id','name_km','full_name_km','address_km','province_id','district_id','commune_id'
    ];

    public function scopeSearch($query, $searchText)
    {
        if(isset($searchText)){
            $query->where("address_km","LIKE","%$searchText%");
        }
        return $query;
    }
}
