<?php

namespace App\Repository;
use Carbon\Carbon;

use App\Helpers\Helper;
use Illuminate\Support\Facades\DB;
use App\Models\AccReceivableDetails;



class AccReceivableDetailPaidRepository
{
    // Old code -> User.php => public function sumAmountPaid(),..
    public static function getaccDetailPaid($co_id){

        $month = empty(request()->month)?null:date('Y-m',strtotime(request()->month));
        return AccReceivableDetails::select(
            'paid_principal',
            'paid_interest',
            'paid_maintenance',
            'paid_risk',
            'paid_penalty'
        )
        ->where('co_id',$co_id)->where(function($query) use($month){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            if(!request()->date==[]){
                $query->whereBetween(DB::raw("DATE_FORMAT(received_date, '%Y-%m-%d')"), request()->date);
            }
            if(!request()->month ==[]){
                $query->where(DB::raw("DATE_FORMAT(received_date, '%Y-%m')"),'<=',$month);
            }
            if(!request()->co_id ==[]){
                $query->whereIn('co_id',request()->co_id);
            }
        });

    }

    public static function paidPrincipal($co_id)
    {
        return self::getaccDetailPaid($co_id)->sum('paid_principal');
    }

    public static function paidInterest($co_id)
    {
        return self::getaccDetailPaid($co_id)->sum('paid_interest');
    }
    public static function paidMaintenance($co_id)
    {
        return self::getaccDetailPaid($co_id)->sum('paid_maintenance');
    }
    public static function paidRisk($co_id)
    {
        return self::getaccDetailPaid($co_id)->sum('paid_risk');
    }
    public static function paidPenalty($co_id)
    {
        return self::getaccDetailPaid($co_id)->sum('paid_penalty');
    }
    public static function getTotalPaid($co_id){
        return self::paidprincipal($co_id) + self::paidinterest($co_id) + self::paidmaintenance($co_id) + self::paidrisk($co_id);
    }
}
