<?php

namespace App\Repository;
use Carbon\Carbon;

use App\Models\Loan;
use App\Helpers\Helper;
use App\Models\Holiday;
use App\Models\AccReceivables;
use Illuminate\Support\Facades\DB;


class ClientLateRepository
{
    public static function getAccLate($loan_id)
  {
    // $data = AccReceivables::where(function($qeury){
    // //   if(request()->type_collection == 1){
    // //     $qeury->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),date('Y-m-d')); // Daily Collection
    // //   }
    // //   else if(request()->type_collect_late==1){
    // //     $qeury->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d')); // Collect Late with today
    // //   }
    // //   else{
    // //     $qeury->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<',date('Y-m-d')); // Late Collection
    // //   }
    // $qeury->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d')); // Collect Late with today
    // })
    // ->where('loan_id',$loan_id)
    // ->whereIn('payment_status_id',[2,3]);
    // return $data;

    $data = AccReceivables::
    whereDate('payment_date','<=',date('Y-m-d'))
    ->where('loan_id',$loan_id)
    ->whereIn('payment_status_id',[2,3]);
    return $data;
  }

  public static function getAccDetails($loan_id){
     $data = AccReceivables::leftjoin('acc_receivable_details','acc_receivable_details.acc_id','acc_receivables.id')
        // ->where(function($qeury){
        //     // if(request()->type_collection == 1){
        //     // $qeury->where(DB::raw("DATE_FORMAT(acc_receivables.payment_date, '%Y-%m-%d')"),date('Y-m-d')); // Daily Collection
        //     // }
        //     // else if(request()->type_collect_late==1){
        //     // $qeury->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d')); // Collect Late with today
        //     // }
        //     // else{
        //     // $qeury->where(DB::raw("DATE_FORMAT(acc_receivables.payment_date, '%Y-%m-%d')"),'<',date('Y-m-d')); // Late Collection
        //     // }
        //     $qeury->where(DB::raw("DATE_FORMAT(payment_date, '%Y-%m-%d')"),'<=',date('Y-m-d')); // Collect Late with today
        // })
        ->whereDate('acc_receivables.payment_date','<=',date('Y-m-d'))
        ->whereNull('acc_receivable_details.deleted_at')
        ->where('acc_receivables.loan_id',$loan_id)
        ->whereIn('acc_receivables.payment_status_id',[2,3]);
        return $data;


  }
    // public static function clientLate($loan_id,$client_id)
    // {

    //     $loanData = Loan::where('id',$loan_id)->select('term_condi','currency_id')->first();
    //     $firstIdLate = self::getAccLate($loan_id)->where('client_id',$client_id)->min('id');
    //     $acc = AccReceivables::find($firstIdLate);

    //     if (!$acc) return '';

    //     $search_date = is_array(request()->date) ? null : Carbon::parse(request()->date);

    //     $holidayDates = Holiday::pluck('date')->map(function ($date) {
    //         return Carbon::parse($date)->format('Y-m-d');
    //     })->toArray();
    //     $holidaySet = array_flip($holidayDates); // Faster lookup

    //     $payment_date = Carbon::parse($acc->payment_date)->startOfDay();
    //     $today = now()->startOfDay();

    //     if ($search_date && $payment_date >= $search_date) {
    //         return ['total_late' => 0, 'total_penalty' => 0, 'start_date' => 0];
    //     }

    //     $start_date = $payment_date->copy();
    //     $end_date = $today;
    //     $total_late = 0;

    //     while ($start_date->lt($end_date)) {
    //         $is_holiday = isset($holidaySet[$start_date->format('Y-m-d')]);

    //         switch ($loanData->term_condi) {
    //             case 1: // Mon-Fri
    //                 if (!$start_date->isWeekend() && !$is_holiday) $total_late++;
    //                 break;
    //             case 2: // Mon-Sat
    //                 if (!$start_date->isSunday() && !$is_holiday) $total_late++;
    //                 break;
    //             default: // All days except holidays
    //                 if (!$is_holiday) $total_late++;
    //         }

    //         $start_date->addDay();
    //     }

    //     $penalty = 0;
    //     if ($total_late > 0) {
    //         $penalty = $loanData->currency_id == 1
    //             ? round($total_late * 2000, -2, PHP_ROUND_HALF_ODD)
    //             : round($total_late * 0.5, 2);
    //     }

    //     return [
    //         'total_lates' => $total_late,
    //         'total_penaltys' => $penalty,
    //         'start_dates' => $payment_date->toDateString(),
    //     ];
    // }

    public static function getPrincipalLate($loan_id){
        $AccReceivables = self::getAccLate($loan_id)->sum('principal');
        $Detail = self::getAccDetails($loan_id)->sum('acc_receivable_details.paid_principal');
        return $AccReceivables - $Detail;
    }
    public static function getInterestLate($loan_id){
        $AccReceivables = self::getAccLate($loan_id)->sum('interest_per_month');
        $Detail = self::getAccDetails($loan_id)->sum('acc_receivable_details.paid_interest');
        return $AccReceivables - $Detail;
    }
    public static function getRisklate($loan_id){
        $AccReceivables = self::getAccLate($loan_id)->sum('risk_per_month');
        $Detail = self::getAccDetails($loan_id)->sum('acc_receivable_details.paid_risk');
        return $AccReceivables - $Detail;
    }
    public static function getMaintenancelate($loan_id){
        $AccReceivables = self::getAccLate($loan_id)->sum('maintenance_per_month');
        $Detail = self::getAccDetails($loan_id)->sum('acc_receivable_details.paid_maintenance');
        return $AccReceivables - $Detail;
    }
    public static function getReceivedlate($loan_id){
        return self::getAccLate($loan_id)->sum('received');
    }
    public static function unReceivedlate($loan_id){
        return self::getAccLate($loan_id)->sum('unreceived');
    }
    // Old code ->AccReceivable =>getTotalBalancePrincipalsAttribute
    public static function getBalancePrincipal(){
        $currency = Helper::byCurrency();
        $branches = Helper::byBranch();
        return DB::table('loans')
            ->leftjoin('users', 'loans.co_id', '=', 'users.id')
            ->leftjoin('clients', 'loans.client_id', '=', 'clients.id')
            ->where('users.status',1)
            ->where('clients.status',1)
            ->whereIn('loans.branch_id', $branches)
            ->where('loans.currency_id', $currency) // FIXED: Changed back to where()
            ->whereNotIn('loans.loan_status_id',[1,4,6])
            ->sum('loans.balance_principal');
    }
}
