<?php

namespace App\Repository;
use Carbon\Carbon;

use App\Models\Loan;
use App\Helpers\Helper;
use App\Models\AccReceivables;
use Illuminate\Support\Facades\DB;
use App\Models\AccReceivableDetails;


class LoanBalanceAmountRepository
{
    // old code -> User.php => getbalanceinterestAttribute,...
    public static function getLoanBalance($co_id){
          return Loan::where('co_id',$co_id)
        ->where(function($query){
            $query->whereIn('branch_id',Helper::byBranch());
            $query->where('currency_id',Helper::byCurrency());
            if(!request()->client_id ==[]){
                $query->whereIn('client_id',request()->client_id);
            }
            if(!request()->co_id ==[])
            {
                $query->whereIn('co_id',request()->co_id);
            }
        });
    }

    public static function balanceinterest($co_id)
    {
         return self::getLoanBalance($co_id)->sum('balance_interest');
    }
     public static function balanceisk($co_id)
    {
        return self::getLoanBalance($co_id)->sum('balance_risk');
    }

     public static function balancemaintenance($co_id)
    {
       return self::getLoanBalance($co_id)->sum('balance_maintenance');
    }

    // Old code -> User.php => getbalanceprincipalAttribute
    // public static function getBalancePrincipals($co_id){
    //     $branches = Helper::byBranch();
    //     $currencies = Helper::byCurrency();

    //     $month = empty(request()->month)?null:date('Y-m',strtotime(request()->month));
    //     $principal=  AccReceivables::where('co_id', $co_id)
    //     ->whereHas('loan', function($query)  use($month, $branches,$currencies){
    //         $query->whereIn('branch_id', $branches);
    //         $query->where('currency_id', $currencies);
    //         $query->where('loan_status_id',2);
    //         if(!request()->date ==[]){
    //             $query->where(DB::raw("DATE_FORMAT(installment_date, '%Y-%m')"),'<=',$month);
    //         }
    //         if(!request()->co_id ==[])
    //         {
    //             $query->whereIn('co_id',request()->co_id);
    //         }
    //     })
    //     ->sum('principal');

    //      $paid_principal = AccReceivableDetails::where('co_id', $co_id)
    //         ->whereHas('loan', function($q) use ($branches, $currencies) {
    //             $q->where('loan_status_id', 2)
    //             ->whereIn('branch_id', $branches)
    //             ->where('currency_id', $currencies)
    //             ->whereHas('co', fn($q) => $q->where('status', 1))
    //             ->whereHas('client', fn($q) => $q->where('status', 1));
    //         })
    //         ->sum('paid_principal');

    //     return $principal-$paid_principal;
    // }
     // Old code -> User.php => getbalanceprincipalAttribute
    public static function getBalancePrincipals($co_id)
    {
        // --- Pre-calculate values to avoid repeating calls ---
        $branches = Helper::byBranch();
        $currency = Helper::byCurrency(); // Renamed to singular for clarity
        $endDate = null;

        // Make the date check index-friendly (SARGable)
        if (!empty(request()->month) && !request()->date == []) {
            // Get the last day of the given month to ensure the entire month is included
            $endDate = date('Y-m-t', strtotime(request()->month));
        }

        // --- Query 1: Calculate total principal using JOINs ---
        $principal = AccReceivables::query()
            ->leftjoin('loans', 'acc_receivables.loan_id', '=', 'loans.id')
            ->where('acc_receivables.co_id', $co_id)
            ->whereIn('loans.branch_id', $branches)
            ->where('loans.currency_id', $currency) // FIXED: Changed back to where()
            ->where('loans.loan_status_id', 2);

        // Apply the date condition if it exists
        if ($endDate) {
            $principal->where('loans.installment_date', '<=', $endDate);
        }

        $principal = $principal->sum('acc_receivables.principal');


        // --- Query 2: Calculate paid principal using JOINs ---
        $paid_principal = AccReceivableDetails::query()
            ->leftjoin('loans', 'acc_receivable_details.loan_id', '=', 'loans.id')
            ->leftjoin('users', 'loans.co_id', '=', 'users.id')
            ->leftjoin('clients', 'loans.client_id', '=', 'clients.id')
            ->where('acc_receivable_details.co_id', $co_id)
            ->where('loans.loan_status_id', 2)
            ->whereIn('loans.branch_id', $branches)
            ->where('loans.currency_id', $currency) // FIXED: Changed back to where()
            ->where('users.status', 1)
            ->where('clients.status', 1)
            ->sum('acc_receivable_details.paid_principal');

        return $principal - $paid_principal;
    }

     public static function getLoanLates($co_id){
           $baseQuery = AccReceivables::query()
            ->where('co_id', $co_id)
            ->whereIn('branch_id', Helper::byBranch())
            ->where('currency_id', Helper::byCurrency())
            ->where('payment_date', '<', now()->toDateString())
            ->whereIn('payment_status_id', [2, 3])
            ->when(request()->filled('client_id'), function ($query) {
                $query->whereIn('client_id', (array) request()->client_id);
            })
            ->when(request()->filled('co_id'), function ($query) {
                $query->whereIn('co_id', (array) request()->co_id);
            })
            ->whereHas('co', fn($q) => $q->where('status', 1))
            ->whereHas('client', fn($q) => $q->where('status', 1));

        return [
            'late'   => (clone $baseQuery)->groupBy('loan_id')->get()->count(),
            'amount' => (clone $baseQuery)->sum('principal')
        ];
     }

}
