<?php

namespace App\Traits;

use Carbon\Carbon;

trait FormatDate
{

    protected $dateTimeFormatDisplay = 'd-m-Y h:s A';
    protected $dateFormatDisplay = 'd-m-Y';


    /**
     * The attributes that should be format date time.
     *
     * @var string
     */
    public function getDateTimeFormatAttribute($date)
    {

        return Carbon::parse($date)->format($this->dateTimeFormatDisplay);
    }

    /**
     * The attributes that should be format date.
     *
     * @var string
     */
    public function getDateFormatAttribute($date)
    {

        return Carbon::parse($date)->format($this->dateFormatDisplay);
    }
}
