<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBranchesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->string('name_en',100)->nullable();
            $table->string('name_km',100)->nullable();
            $table->string('phone',100)->nullable();
            $table->string('address',200)->nullable();
            $table->string('province_id',2)->nullable();
            $table->string('district_id',4)->nullable();
            $table->string('commune_id',6)->nullable();
            $table->string('village_id',8)->nullable();
            $table->tinyInteger('created_by');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('branches');
    }
}
