<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->references('id')->on('branches')->default(1);
            $table->foreignId('currency_id')->references('id')->on('currencies')->default(1);
            $table->string('code',15);
            $table->string('name');
            $table->string('nickname',50)->nullable();
            $table->tinyInteger('gender')->comment('1 => Male, 2= Female')->default(1);
            $table->string('email')->nullable()->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('last_seen')->nullable();
            $table->string('contact_number',50)->nullable();
            $table->string('password')->nullable();
            $table->string('photo')->nullable();
            $table->tinyInteger('type_document')->nullable();
            $table->string('id_card',20)->nullable();
            $table->string('place_of_birth',200)->nullable();
            $table->date('date_of_birth')->nullable();
            $table->date('create_card_date')->nullable();
            $table->date('expired_card_date')->nullable();
            $table->date('date_start_working')->nullable();
            $table->string('work_place',100)->nullable();
            $table->string('institution',200)->nullable();
            $table->string('position',100)->nullable();
            $table->string('address')->nullable();
            $table->string('province_id',2)->nullable();
            $table->string('district_id',4)->nullable();
            $table->string('commune_id',6)->nullable();
            $table->string('village_id',8)->nullable();
            $table->tinyInteger('type')->comment('1 => User, 2= Co')->default(1);
            $table->tinyInteger('status')->comment('1 => Active, 2= Inactive')->default(1);
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**position
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
