<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('code',8)->nullable();
            $table->string('name_en',100)->nullable();
            $table->string('name_kh',120)->nullable();
            $table->string('contact_number',50)->nullable();
            $table->string('email',50)->nullable();;
            $table->string('website',120)->nullable();
            $table->string('address',200)->nullable();
            $table->string('logo',100)->nullable();
            $table->tinyInteger('status')->comment('1 => Active, 2= Inactive')->default(1);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
