<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepreciationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('depreciations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->references('id')->on('assets');
            $table->foreignId('created_by')->references('id')->on('users');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->integer('chart_asset');
            $table->integer('chart_expense');
            $table->date('depreciation_date');
            $table->integer('period');
            $table->double('total_amount',15,3)->default(0);
            $table->double('total_paid',15,3)->default(0);
            $table->double('balance',15,3)->default(0);
            $table->string('desc',255)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('depreciations');
    }
}
