<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepreciationDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('depreciation_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dep_id')->references('id')->on('depreciations');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->date('payment_date');
            $table->date('paid_date')->nullable();
            $table->double('amount',15,3);
            $table->double('paid',15,3);
            $table->double('unpaid',15,3);
            $table->double('loan_balance',15,3);
            $table->integer('status')->comment('1=>Unpaid,2=>Paid,3=>Deleted');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('depreciation_details');
    }
}
