<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepreciationPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('depreciation_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dep_detail_id')->references('id')->on('depreciation_details');
            $table->foreignId('created_by')->references('id')->on('users');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->date('paid_date');
            $table->double('paid',15,3);
            $table->double('loan_balance',15,3);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('depreciation_payments');
    }
}
