<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->string('code',20)->nullable();
            $table->string('name',100);
            $table->string('name_en',100);
            $table->string('phone',15)->nullable();
            $table->tinyInteger('gender')->comment('1=Male,2=Female');
            $table->tinyInteger('type_document')->nullable();
            $table->string('id_card',20)->nullable();
            $table->string('issued_by',200)->nullable();
            $table->string('place_of_birth',200)->nullable();
            $table->date('date_of_birth')->nullable();
            $table->date('create_card_date')->nullable();
            $table->date('expired_card_date')->nullable();
            $table->string('work_place',100)->nullable();
            $table->string('institution',200)->nullable();
            $table->string('position',100)->nullable();
            $table->string('address')->nullable();
            $table->float('income')->default(0.00);
            $table->float('expense')->default(0.00);
            $table->float('balance')->default(0.00);
            $table->string('province_id',2)->nullable();
            $table->string('district_id',4)->nullable();
            $table->string('commune_id',6)->nullable();
            $table->string('village_id',8)->nullable();
            $table->string('village_kh',100)->nullable();
            $table->string('relationship',200)->nullable();
            $table->string('photo',200)->nullable();
            $table->text('remark')->nullable();
            $table->tinyInteger('created_by');
            $table->tinyInteger('status')->default(1)->comment('1=Active, 2 = Inactive');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
}
