<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->id();
            $table->string('loan_code',100)->nullable();
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->foreignId('client_id')->references('id')->on('clients');
            $table->foreignId('co_id')->references('id')->on('users');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->date('completed_date')->nullable();
            $table->date('installment_date')->nullable();
            $table->date('start_date')->nullable();
            $table->double('reschedule_amount',20,2)->default(0.00);
            $table->double('loan_out',20,2)->default(0.00);
            $table->double('risk',4,2)->default(0.00);
            $table->double('total_risk',20,2)->default(0.00);
            $table->double('interest',4,2)->default(0.00);
            $table->double('total_interest',20,2)->default(0.00);
            $table->double('maintenance',4,2)->default(0.00);
            $table->double('total_maintenance',20,2)->default(0.00);
            $table->double('service',4,2)->default(0.00);
            $table->double('total_service',20,2)->default(0.00);
            $table->double('service_collection',4,2)->default(0.00);
            $table->double('total_collection',20,2)->default(0.00);
            $table->double('loan_receive',20,2)->default(0.00);
            $table->double('balance_principal',20,2)->default(0.00);
            $table->double('balance_interest',20,2)->default(0.00);
            $table->double('balance_risk',20,2)->default(0.00);
            $table->double('balance_maintenance',20,2)->default(0.00);
            $table->double('loan_balance',20,2)->default(0.00);
            $table->double('paid_principal',20,2)->default(0.00);
            $table->double('paid_interest',20,2)->default(0.00);
            $table->double('paid_risk',20,2)->default(0.00);
            $table->double('paid_maintenance',20,2)->default(0.00);
            $table->double('loan_in',20,2)->default(0.00);
            $table->double('total_penalty',20,2)->default(0.00);
            $table->integer('period',)->default(0);
            $table->integer('term_type',)->default(0);
            $table->integer('condition_pay',)->default(0);
            $table->integer('loan_status_id')->default(0);
            $table->integer('type_loan')->default(1)->comment('1=personal,2=team');
            $table->dateTime('closing_date')->nullable();
            $table->integer('approved_by')->nullable();
            $table->integer('closing_by')->nullable();
            $table->text('desc')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loans');
    }
}
