<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccReceivablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('acc_receivables', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->foreignId('loan_id')->references('id')->on('loans');
            $table->foreignId('client_id')->references('id')->on('clients');
            $table->foreignId('co_id')->references('id')->on('users');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->integer('acc_parent_id')->nullable();
            $table->integer('num');
            $table->integer('count_day');
            $table->date('payment_date')->nullable();
            $table->date('received_date')->nullable();
            $table->float('principal',15, 2)->default(0.00);
            $table->float('risk_per_month',15, 2)->default(0.00);
            $table->float('interest_per_month',15, 2)->default(0.00);
            $table->float('maintenance_per_month',15, 2)->default(0.00);
            $table->float('payment_per_month',15, 2)->default(0.00);
            $table->float('received',15, 2)->default(0.00);
            $table->float('unreceived',15, 2)->default(0.00);
            $table->float('loan_balance',15, 2)->default(0.00);
            $table->float('penalty',8, 2)->default(0.00);
            $table->integer('payment_status_id')->default(1);
            $table->integer('open_close')->default(1);//1=close,2=open
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('acc_receivables');
    }
}
