<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccReceivableDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('acc_receivable_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->foreignId('loan_id')->references('id')->on('loans');
            $table->foreignId('client_id')->references('id')->on('clients');
            $table->foreignId('co_id')->references('id')->on('users');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->foreignId('acc_id')->references('id')->on('acc_receivables');
            $table->date('received_date')->nullable();
            $table->float('paid_principal',15, 2)->default(0.00);
            $table->float('paid_risk',15, 2)->default(0.00);
            $table->float('paid_interest',15, 2)->default(0.00);
            $table->float('paid_maintenance',15, 2)->default(0.00);
            $table->float('received',15, 2)->default(0.00);
            $table->float('unreceived',15, 2)->default(0.00);
            $table->float('paid_penalty',15, 2)->default(0.00);
            $table->integer('status')->default(1);
            $table->integer('condition_payment')->default(1);
            $table->dateTime('closing_date')->nullable();
            $table->integer('closing_by')->nullable();
            $table->integer('approved_by')->nullable()->comment('approved by cashier');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('acc_receivable_details');
    }
}
