<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVillagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('villages', function (Blueprint $table) {
            $table->id();
            $table->string('name_km',50);
            $table->string('full_name_km',50);
            $table->foreignId('province_id')->references('id')->on('provinces');
            $table->foreignId('district_id')->references('id')->on('districts');
            $table->foreignId('commune_id')->references('id')->on('communes');
            $table->string('address_km',200);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('villages');
    }
}
