<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBackPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('back_payments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('acc_id');
            $table->integer('loan_id');
            $table->integer('branch_id');
            $table->integer('currency_id');
            $table->integer('co_id');
            $table->integer('client_id');
            $table->integer('num');
            $table->date('payment_date');
            $table->float('interest_per_month',15, 2)->comment(' Interest per month ');
            $table->float('risk_per_month',15, 2)->comment(' Risk per month ');
            $table->float('maintenance_per_month',15, 2)->comment(' Maintenance per month ');
            $table->float('principal',15, 2)->comment(' Loan out per month ');
            $table->float('loan_balance',15, 2)->comment(' Loan - Loan out per month ');
            $table->float('payment_per_month',15, 2)->comment('Interest per month + Loan out per month');
            $table->float('unreceived',15, 2)->default(0.00)->comment(' Unreceived from client ');
            $table->integer('payment_status_id')->default(1);//1=paid,2=partail,3=unpaid
            $table->integer('open_close')->default(1);//1=close,2=open
            $table->integer('status')->default(1);//1=not back , 2=back
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('back_payments');
    }
}
