<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCollateralDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('collateral_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('loan_id')->references('id')->on('loans');
            $table->foreignId('client_id')->references('id')->on('clients');
            $table->foreignId('collateral_id')->references('id')->on('collaterals');
            $table->string('model_type',200)->nullable();
            $table->string('degree',200)->nullable();
            $table->string('number',100)->nullable();
            $table->string('number_plate',100)->nullable();
            $table->year('year')->nullable();
            $table->string('color',200)->nullable();
            $table->string('body_number',200)->nullable();
            $table->string('engine_number',200)->nullable();
            $table->string('cylinder_size',200)->nullable();
            $table->string('head_land',200)->nullable();
            $table->string('size',200)->nullable();
            $table->string('issued_by',200)->nullable();
            $table->string('location',200)->nullable();
            $table->date('date_made')->nullable();
            $table->float('price_market',200)->nullable();
            $table->float('price_urgent',200)->nullable();
            $table->integer('status_type')->default(1);
            $table->integer('status')->default(1);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('collateral_details');
    }
}
