<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->integer('parent_id');
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->foreignId('created_by')->references('id')->on('users');
            $table->foreignId('chart_of_acc_id')->references('id')->on('chart_of_accounts');
            $table->morphs('payment_model');
            $table->string('invoice_number',150);
            $table->double('debit',15,3)->nullable()->default(0.00);
            $table->double('credit',15,3)->nullable()->default(0.00);
            $table->date('expense_date');
            $table->string('desc',255)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expenses');
    }
}
