<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReschedulesTable extends Migration
{
    public function up()
    {
        Schema::create('reschedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('branch_id')->references('id')->on('branches');
            $table->foreignId('loan_id')->references('id')->on('loans');
            $table->foreignId('client_id')->references('id')->on('clients');
            $table->foreignId('co_id')->references('id')->on('users');
            $table->foreignId('currency_id')->references('id')->on('currencies');
            $table->float('principal',20,2)->default(0.00);
            $table->float('remail_amount',20,2)->default(0.00);
            $table->float('amount',20,2)->default(0.00);
            $table->integer('status')->default(1)->comment('1=principal_down,2=principal_up');
            $table->date('date')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reschedules');
    }
}
