<?php

namespace Database\Seeders;

use App\Models\Branch;
use App\Models\Currency;
use Illuminate\Database\Seeder;

class BranchSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
      
        Branch::updateOrCreate(
            ['id' =>1], [
            'name_en' =>'Phnom Penh',
            'name_km' =>'សាខារាជធានីភ្នំពេញ',
            'address' =>'សាខារាជធានីភ្នំពេញ',
            'province_id' =>1,
            'district_id' =>101,
            'commune_id' =>10101,
            'village_id' =>1010101,
        ]);
        Branch::updateOrCreate(
            ['id' =>2], [
            'name_en' =>'Kandal',
            'name_km' =>'សាខាខេត្តកណ្ដាល',
            'address' =>'សាខាខេត្តកណ្ដាល',
            'province_id' =>1,
            'district_id' =>101,
            'commune_id' =>10101,
            'village_id' =>1010101,
        ]);

        Currency::updateOrCreate(
            ['id' =>1], [
            'currency_en' =>'Reil',
            'currency_km' =>'Reil',
            'symbol' =>'៛',
        ]);
        Currency::updateOrCreate(
            ['id' =>2], [
            'currency_en' =>'USD',
            'currency_km' =>'USD',
            'symbol' =>'$',
        ]);
    }
}
