<?php

namespace Database\Seeders;

use App\Models\Accounting\ChartOfAccount;
use Illuminate\Database\Seeder;

class ChartOfAccountSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $chart_of_accounts = array(
            array('id' => '1','created_by' => '1','type_of_acc_detail_id' => '1','chart_code' => '10001','chart_name' => 'Cash On Hand','desc' => 'សាច់ប្រាក់ក្នុងដៃ','payment' => '1','deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '2','created_by' => '1','type_of_acc_detail_id' => '4','chart_code' => '30001','chart_name' => 'Owner\'s Capital Contribution','desc' => 'ដើមទុនម្ចាស់ភាគហ៊ុនដាក់បន្ថែម','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '3','created_by' => '1','type_of_acc_detail_id' => '5','chart_code' => '40001','chart_name' => 'Principal income','desc' => 'ចំណូលបានមកពីប្រាក់ដើម','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '4','created_by' => '1','type_of_acc_detail_id' => '5','chart_code' => '40002','chart_name' => 'Interest incom','desc' => 'ចំណូលបានមកពីការប្រាក់','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '5','created_by' => '1','type_of_acc_detail_id' => '5','chart_code' => '40003','chart_name' => 'Risk service income','desc' => 'ចំណូលបានមកពីសេវាហានិភ័យ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '6','created_by' => '1','type_of_acc_detail_id' => '5','chart_code' => '40004','chart_name' => 'Administrative service income','desc' => 'ចំណូលបានមកពីសេវារដ្ឋបាល','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '7','created_by' => '1','type_of_acc_detail_id' => '5','chart_code' => '40005','chart_name' => 'Collection service income','desc' => 'ចំណូលបានមកពីសេវាប្រមូលប្រាក់','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '8','created_by' => '1','type_of_acc_detail_id' => '5','chart_code' => '40006','chart_name' => 'Penalty income','desc' => 'ចំណូលបានមកពីប្រាក់ពិន័យ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '9','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50001','chart_name' => 'Loan Disbursed expense','desc' => 'ចំណាយលើប្រាក់កម្ចីទៅអោយអតិថិជន','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-09 15:51:09','updated_at' => '2023-03-09 15:51:09'),
  array('id' => '10','created_by' => '1','type_of_acc_detail_id' => '1','chart_code' => '10002','chart_name' => 'Cash In Bank (ABA)','desc' => 'សាច់ប្រាក់ក្នុងធនាគារ (ABA)','payment' => '2','deleted_at' => NULL,'created_at' => '2023-03-24 14:03:24','updated_at' => '2023-03-24 14:03:24'),
  array('id' => '11','created_by' => '1','type_of_acc_detail_id' => '1','chart_code' => '10003','chart_name' => 'Cash In Bank (ACLIDA)','desc' => 'សាច់ប្រាក់ក្នុងធនាគារ (ACLIDA)','payment' => '2','deleted_at' => NULL,'created_at' => '2023-03-24 14:08:48','updated_at' => '2023-03-24 14:08:48'),
  array('id' => '12','created_by' => '1','type_of_acc_detail_id' => '1','chart_code' => '10004','chart_name' => 'Cash In Bank (Wing)','desc' => 'សាច់ប្រាក់ក្នុងធនាគារ (Wing)','payment' => '2','deleted_at' => NULL,'created_at' => '2023-03-24 14:09:26','updated_at' => '2023-03-24 14:09:26'),
  array('id' => '13','created_by' => '1','type_of_acc_detail_id' => '1','chart_code' => '10005','chart_name' => 'Other Current Assets','desc' => 'ទ្រព្យសកម្មផ្សេងៗ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:09:50','updated_at' => '2023-03-24 14:09:50'),
  array('id' => '14','created_by' => '1','type_of_acc_detail_id' => '3','chart_code' => '20001','chart_name' => 'Salary Payable','desc' => 'ការជំពាក់លើប្រាក់ខែមន្រ្តីឥណទាន','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:10:33','updated_at' => '2023-03-24 14:10:33'),
  array('id' => '15','created_by' => '1','type_of_acc_detail_id' => '3','chart_code' => '20002','chart_name' => 'Unearned Revenues','desc' => 'ទឹកប្រាក់ទទួលបានពីអតិថិជនដែលមិនទាន់បានបំពេញសេវាកម្ម','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:11:05','updated_at' => '2023-03-24 14:11:05'),
  array('id' => '16','created_by' => '1','type_of_acc_detail_id' => '3','chart_code' => '20003','chart_name' => 'Account Payable','desc' => 'សាច់ប្រាក់ដែលស្ថាប័នជំពាក់អ្នកផ្គត់ផ្គង់','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:11:25','updated_at' => '2023-03-24 14:11:25'),
  array('id' => '17','created_by' => '1','type_of_acc_detail_id' => '3','chart_code' => '20004','chart_name' => 'Other Current Liabilities','desc' => 'បំណុលសកម្មផ្សេង','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:11:42','updated_at' => '2023-03-24 14:11:42'),
  array('id' => '18','created_by' => '1','type_of_acc_detail_id' => '4','chart_code' => '30002','chart_name' => 'Paid up Share Capital','desc' => 'ដើមទុនចុះបញ្ជី','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:12:07','updated_at' => '2023-03-24 14:12:07'),
  array('id' => '19','created_by' => '1','type_of_acc_detail_id' => '4','chart_code' => '30004','chart_name' => 'Owner\'s Capital Drawing','desc' => 'ការដកដើមទុនរបស់ម្ចាស់ភាគហ៊ុន','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:12:45','updated_at' => '2023-03-24 14:12:45'),
  array('id' => '20','created_by' => '1','type_of_acc_detail_id' => '4','chart_code' => '30003','chart_name' => 'Dividend','desc' => 'បែងចែកភាគលាភ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:13:11','updated_at' => '2023-03-24 14:13:11'),
  array('id' => '21','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50002','chart_name' => 'Office Rental','desc' => 'ចំណាយលើការជួលការិយាល័យ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:13:35','updated_at' => '2023-03-24 14:13:35'),
  array('id' => '22','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50003','chart_name' => 'Utilities','desc' => 'ចំណាយលើការប្រើប្រាស់ទឹក ភ្លើង','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:13:56','updated_at' => '2023-03-24 14:13:56'),
  array('id' => '23','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50004','chart_name' => 'Salary Expense','desc' => 'ចំណាយលើប្រាក់បៀវត្សន៍មន្រ្តីឥណទាន','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:14:16','updated_at' => '2023-03-24 14:14:16'),
  array('id' => '24','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50005','chart_name' => 'Stationary Expense','desc' => 'ចំណាយលើសម្ភារៈការិយាល័យ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:14:39','updated_at' => '2023-03-24 14:14:39'),
  array('id' => '25','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50006','chart_name' => 'Maintenance','desc' => 'ចំណាយលើការថែទាំ និងជួសជុល','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:14:57','updated_at' => '2023-03-24 14:14:57'),
  array('id' => '26','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50007','chart_name' => 'Travel Expense','desc' => 'ចំណាយលើមធ្យោបាយធ្វើដំណើរ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:15:19','updated_at' => '2023-03-24 14:15:19'),
  array('id' => '27','created_by' => '1','type_of_acc_detail_id' => '8','chart_code' => '50008','chart_name' => 'Other Operating Expense','desc' => 'ចំណាយប្រតិបត្តិការផ្សេងៗ','payment' => NULL,'deleted_at' => NULL,'created_at' => '2023-03-24 14:15:42','updated_at' => '2023-03-24 14:15:42')
          );

        foreach ($chart_of_accounts as  $value) {
            ChartOfAccount::updateOrCreate(['id' => $value['id']],[
                'created_by'     => $value['created_by'],
                'type_of_acc_detail_id'     => $value['type_of_acc_detail_id'],
                'chart_code'     => $value['chart_code'],
                'chart_name' => $value['chart_name'],
                'desc'           => $value['desc'],
            ]);
        }
    }
}
