<?php

namespace Database\Seeders;

use App\Models\Accounting\TypeOfAccDetail;
use Illuminate\Database\Seeder;

class TypeOfAccDetailSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $type_acc_details = [
            [
                'id' => 1,
                'created_by' => 1,
                'type_of_acc_id' => 10,
                'name' => 'Current Asset',
                'remark' => 'Current Asset',
            ],
            [
                'id' => 2,
                'created_by' => 1,
                'type_of_acc_id' => 10,
                'name' => 'Fixed Asset',
                'remark' => 'Fixed Asset',
            ],
            [
                'id' => 3,
                'created_by' => 1,
                'type_of_acc_id' => 20,
                'name' => 'Current Liabilities',
                'remark' => 'Current Liabilities',
            ],
            [
                'id' => 4,
                'created_by' => 1,
                'type_of_acc_id' => 30,
                'name' => 'Equity',
                'remark' => 'Equity',
            ],
            [
                'id' => 5,
                'created_by' => 1,
                'type_of_acc_id' => 40,
                'name' => 'Income',
                'remark' => 'Income',
            ],
            [
                'id' => 6,
                'created_by' => 1,
                'type_of_acc_id' => 40,
                'name' => 'Other Income',
                'remark' => 'Other Income',
            ],
            [
                'id' => 7,
                'created_by' => 1,
                'type_of_acc_id' => 50,
                'name' => 'Cost of Good Sold',
                'remark' => 'Cost of Good Sold',
            ],
            [
                'id' => 8,
                'created_by' => 1,
                'type_of_acc_id' => 50,
                'name' => 'Expense',
                'remark' => 'Expense',
            ],

        ];
        foreach ($type_acc_details as  $value) {
            TypeOfAccDetail::updateOrCreate(['id' => $value['id']],[
                'created_by'     => $value['created_by'],
                'type_of_acc_id' => $value['type_of_acc_id'],
                'name'           => $value['name'],
                'remark'         => $value['remark'],
            ]);
        }
    }
}
