<?php

namespace Database\Seeders;

use App\Models\Accounting\TypeOfAccount;
use Illuminate\Database\Seeder;

class TypeOfAccountSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $type_acc = [
            [
                'id' => 10,
                'type_name' => 'Asset',
                'desc' => 'The asset account represents the value of the assets owned by the business.',
            ],
            [
                'id' => 20,
                'type_name' => 'Liabilities',
                'desc' => 'A liability account represents a type of debt or future cost for the business.',
            ],
            [
                'id' => 30,
                'type_name' => 'Equity',
                'desc' => 'An equity account represents the value that has been invested or created in the company.',
            ],
            [
                'id' => 40,
                'type_name' => 'Income',
                'desc' => 'Income accounts are used to track the source of revenue.	',
            ],
            [
                'id' => 50,
                'type_name' => 'Expense',
                'desc' => 'An expense account is used to track money spent on any product or service that does not have a resale value.',
            ],
        ];
        foreach ($type_acc as  $value) {
            TypeOfAccount::updateOrCreate(['id' => $value['id']],[
                'type_name' => $value['type_name'],
                'desc'      => $value['desc'],
            ]);
        }
    }
}
