require('./bootstrap');
require('@thyrith/momentkh')(moment);
window.Vue = require('vue').default;
window.Fire = new Vue;
Vue.config.productionTip = false;
import App from './App.vue';
import VueI18n from 'vue-i18n';
import { router } from './router';
import store from "./store/index";
import mixin from "./mixins";
import Chartkick from 'vue-chartkick'
import Highcharts from 'highcharts'
import Form from 'vform'
import Multiselect from '@vueform/multiselect/dist/multiselect.vue2.js'
import '@vueform/multiselect/themes/default.css';
import Toast from "vue-toastification";
import "vue-toastification/dist/index.css";
import VueConfirmDialog from 'vue-confirm-dialog'
import Suggestions from 'v-suggestions'
import 'v-suggestions/dist/v-suggestions.css'
import DatePicker from 'vue2-datepicker';
import 'vue2-datepicker/index.css';
import moment from 'moment'
import VueProgressBar from 'vue-progressbar'
import VueLoading from 'vuejs-loading-plugin'
import InputTag from 'vue-input-tag'
import Vue2Filters from 'vue2-filters';
import Vue from 'vue';
import VueHtmlToPaper from 'vue-html-to-paper';

Vue.use(Chartkick.use(Highcharts))
Chartkick.options = {
    colors: ['#1ab394', '#23c6c8', '#1c84c6', '#df8e15'],
    library: {
        animation: { easing: 'easeOutQuart' },
        yAxis: {
            labels: {
                format: '${value}'
            }
        },
        tooltip: {
            pointFormat: 'Total Spent: <b>{point.y}</b>',
            xDateFormat: '%B',
            valuePrefix: '$'
        }
    }
}

const options = {
    name: '_blank',
    specs: [
        'fullscreen=yes',
        'titlebar=yes',
        'scrollbars=yes'
    ],
    styles: [
        './css/app.css',
        '/css/style-print.css'
    ],
    timeout: 1000,
    autoClose: true,
    windowTitle: window.document.title,
}
Vue.use(VueHtmlToPaper, options);

window.Form = Form;
Vue.use(VueI18n);
Vue.use(Vue2Filters);
Vue.use(Toast);
Vue.use(VueConfirmDialog)
Vue.component('vue-confirm-dialog', VueConfirmDialog.default)
Vue.component('pagination', require('laravel-vue-pagination'));
Vue.component("Multiselect", Multiselect);
Vue.component('suggestions', Suggestions)
Vue.component('input-tag', InputTag)
Vue.mixin(mixin);
Vue.use(DatePicker);
Vue.use(moment);
Vue.use(VueProgressBar, {
    color: '#00FF00',
    failedColor: 'red',
    thickness: '4px',
    transition: {
        speed: '0.2s',
        opacity: '0.6s',
        termination: 300
    },
    autoRevert: true,
    location: 'top',
    inverse: false
})
Vue.use(VueLoading, {
    dark: true, // default false
    text: 'Loading', // default 'Loading'
    background: 'rgba(0,0,0,0.2)'
})

Vue.filter('onlyDate', function(value) {
    if (value) {
        return moment(String(value)).format('DD-MM-YYYY')
    }
});
Vue.filter('dateTime', function(value) {
    if (value) {
        return moment(String(value)).format('DD-MM-YYYY hh:mm a')
    }
});
Vue.filter('numberFomartValue', function(value) {
    if (value) {
        return value.toLocaleString();
    } else {
        return 0;
    }
});
const i18n = new VueI18n({
    locale: localStorage.getItem("lang") || "km",
    messages: {
        en: require("./assets/i18n/en"),
        km: require("./assets/i18n/km")
    }
});
new Vue({
    el: '#app',
    router,
    store,
    i18n,
    render: h => h(App),
});