import Vue from "vue";
import Router from "vue-router";

import Index from './view/layouts/Index.vue'

import NotFoundComponent from './components/NotFoundComponent.vue';
import noPermission from './components/NoPermission.vue';
import PDFView from './components/PDFView.vue';

////////////////////////////// System ///////////////////////////////
/////////////////////////////////////////////////////////////////////
//Admin
import Setting from './view/system/admin/Setting.vue';
import Backup from './view/system/admin/Backup.vue';
import Myprofile from './view/system/admin/Myprofile.vue';

// User
import User from './view/system/user/User.vue';
import UserCreate from './view/system/user/Create.vue';
import UserRole from './view/system/role/UserRole.vue';
import RoleCreate from './view/system/role/Create.vue';

////////////////////////////// End System ///////////////////////////
/////////////////////////////////////////////////////////////////////

//Company
import CompanyList from './view/company/CompanyList.vue';
//Clients
import Clients from './view/client/Clients.vue';
import ClientsCreate from './view/client/ClientsCreate.vue';
//Categories
import Categories from './view/category/Categories.vue';
import CategoriesCreate from './view/category/CategoriesCreate.vue';
//Collateral
import Collaterals from './view/collateral/Collaterals.vue';
import CollateralsCreate from './view/collateral/CollateralsCreate.vue';
//CO
import Co from './view/co/Co.vue';
import CoCreate from './view/co/CoCreate.vue';
//Branch
import Branch from './view/branch/Branch.vue';
import BranchCreate from './view/branch/BranchCreate.vue';
//Currency
import Currency from './view/currency/Currency.vue';
import CurrencyCreate from './view/currency/CurrencyCreate.vue';
//Loan
import Loan from './view/loan/Loan.vue';
import LoanCreate from './view/loan/LoanCreate.vue';
import LoanReschedule from './view/loan/LoanReschedule.vue';
import Payment from './view/loan/Payment.vue';
import TableSchedule from './view/loan/TableSchedule.vue';
import ClientPayment from './view/ClientPayment/ClientPayment.vue';
import CoReceived from './view/ClientPayment/CoReceived.vue';
import CashierReceived from './view/ClientPayment/CashierReceived.vue';
import CoReport from './view/report/CoReport.vue';
import DailyReport from './view/report/DailyReport.vue';
import SavingReport from './view/report/SavingReport.vue';
import CollectionReport from './view/report/CollectionReport.vue';
import CollectedReport from './view/report/CollectedReport.vue';
import CompletedReport from './view/report/CompletedReport.vue';
import BorrowedReport from './view/report/BorrowedReport.vue';
import LateReport from './view/report/LateReport.vue';
import ListApprove from './view/report/ListApprove.vue';
import GetClosingReport from './view/ClientPayment/GetClosingReport.vue';
import SummaryCoReport from './view/report/SummaryCoReport.vue';
import GetLogactivity from './view/logactivity/GetLogactivity.vue';
import Holiday from './view/holiday/Holiday.vue';
import HolidayCreate from './view/holiday/HolidayCreate.vue';
import HistoryPayment from './view/loan/HistoryPayment.vue';
import CollateralList from './view/collateral/CollateralList.vue';
import ContractDay from './view/contracts/ContractDay.vue';
import ContractWeek from './view/contracts/ContractWeek.vue';
import ContractMonth from './view/contracts/ContractMonth.vue';
import permissionTest from './view/client/permissionTest.vue';
import CollateralDetailCreate from './view/collateral/CollateralDetailCreate.vue';
import CollateralListReport from './view/collateral/CollateralListReport.vue';
import ListWriteOff from './view/loan/ListWriteOff.vue';
import PaymentNotClosingReport from "./view/report/not-closing-report/PaymentNotClosingReport.vue";
import LoanNotClosingReport from "./view/report/not-closing-report/LoanNotClosingReport.vue";
import OverdueReport from './view/loan/OverdueReport.vue';
////////////////////////////// END Inventory //////////////////////////
/////////////////////////////////////////////////////////////////////


// dashboard
import Dashboard from './view/dashboards/Dashboard.vue';

// group
import Group from './view/groups/Group.vue';



////////////////////////////// Account ///////////////////////////////////
//////////////////////////////////////////////////////////////////////////
import TypeOfAccountList from './view/accounting/type-account/TypeOfAccountList.vue';
import ChartOfAccountList from './view/accounting/chart-accounts/ChartOfAccountList.vue';

////////////////////////////// Accountant ///////////////////////////////
////////////////////////////////////////////////////////////////////////
import AssetList from './view/accounting/assets/AssetList.vue';
import DepreciationList from './view/accounting/depreciations/DepreciationList.vue';
import PrintSchedule from './view/accounting/depreciations/PrintSchedule.vue';
import MonthlyDepreciation from './view/accounting/depreciations/MonthlyDepreciation.vue';
// import AccountPayable from './view/accounting/account-payable/AccountPayable.vue';
import JournalList from './view/accounting/journals/JournalList.vue';

////////////////////////////// Financial Report ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////
import JournalReport from './view/accounting/financial-reports/JournalReport.vue';
import CashFlow from './view/accounting/financial-reports/CashFlow.vue';
import BalanceSheet from './view/accounting/financial-reports/BalanceSheet.vue';
import NetProfitAndLoss from './view/accounting/financial-reports/NetProfitAndLoss.vue';
import GeneralLedger from './view/accounting/financial-reports/GeneralLedger.vue';
import TrialBalance from './view/accounting/financial-reports/TrialBalance.vue';
import ExpenseList from './view/accounting/expenses/ExpenseList.vue';
import ExpenseReport from './view/accounting/expenses/ExpenseReport.vue';
import IncomeList from './view/accounting/incomes/IncomeList.vue';
import IncomeReport from './view/accounting/incomes/IncomeReport.vue';




Vue.use(Router);

export const router = new Router({
    routes: [

        { path: '/', name: 'Dashboard', component: Dashboard, meta: { title: 'Dashboard' }, },
        // { path: '/*', component: NotFoundComponent, meta: { title: 'Not Found' } },
        // { path: '/no-permission', name: 'noPermission', component: noPermission, meta: { title: 'No Permission' } },
        {
            path: '/system',
            component: Index,
            children: [
                ////////////////////////////// System ///////////////////////////////
                /////////////////////////////////////////////////////////////////////
                { path: '/', name: 'Dashboard', component: Dashboard, meta: { title: 'Dashboard' }, },
                { path: 'setting', name: 'Setting', component: Setting, meta: { title: 'Setting' } },
                { path: 'backup', name: 'Backup', component: Backup },
                { path: 'my-profile', name: 'Myprofile', component: Myprofile, meta: { title: 'Myprofile' } },
                { path: 'user-role', name: 'UserRole', component: UserRole, meta: { title: 'User Role' } },
                { path: 'role-create/:id?', name: 'RoleCreate', component: RoleCreate, meta: { title: 'User Role' } },
                { path: 'user', name: 'User', component: User, meta: { title: 'User' } },
                { path: 'user-create/:id?', name: 'UserCreate', component: UserCreate, props: true, meta: { title: 'UserCreate' } },
                { path: 'company', name: 'CompanyList', component: CompanyList, meta: { title: 'CompanyList' } },


                ////////////////////////////// End System ///////////////////////////
                /////////////////////////////////////////////////////////////////////

                { path: 'pdf-view/:file?', name: 'PDFView', component: PDFView, props: true, meta: { title: 'PDFView' }, props: true },
                { path: 'clients', name: 'Clients', component: Clients, meta: { title: 'Clients' } },
                { path: 'clients-create/:id?', name: 'ClientsCreate', component: ClientsCreate, props: true, meta: { title: 'ClientsCreate' } },
                { path: 'categories', name: 'Categories', component: Categories, meta: { title: 'Categories' } },
                { path: 'categories-create/:id?', name: 'CategoriesCreate', component: CategoriesCreate, props: true, meta: { title: 'CategoriesCreate' } },
                { path: 'collaterals', name: 'Collaterals', component: Collaterals, meta: { title: 'Collaterals' } },
                { path: 'collaterals-create/:id?', name: 'CollateralsCreate', component: CollateralsCreate, props: true, meta: { title: 'CollateralsCreate' } },
                { path: 'co', name: 'Co', component: Co, meta: { title: 'Co' } },
                { path: 'co-create/:id?', name: 'CoCreate', component: CoCreate, props: true, meta: { title: 'CoCreate' } },
                { path: 'branch', name: 'Branch', component: Branch, meta: { title: 'Branch' } },
                { path: 'branch-create/:id?', name: 'BranchCreate', component: BranchCreate, props: true, meta: { title: 'BranchCreate' } },
                { path: 'currency', name: 'Currency', component: Currency, meta: { title: 'Currency' } },
                { path: 'currency-create/:id?', name: 'CurrencyCreate', component: CurrencyCreate, props: true, meta: { title: 'CurrencyCreate' } },
                { path: 'loan', name: 'Loan', component: Loan, meta: { title: 'Loan' } },
                { path: 'loan-create/:id?', name: 'LoanCreate', component: LoanCreate, props: true, meta: { title: 'LoanCreate' } },
                { path: 'loan-reschedule/:id?', name: 'LoanReschedule', component: LoanReschedule, props: true, meta: { title: 'LoanReschedule' } },
                { path: 'list-write-off', name: 'ListWriteOff', component: ListWriteOff, meta: { title: 'ListWriteOff' } },

                { path: 'loan-payment/:id?', name: 'Payment', component: Payment, props: true, meta: { title: 'Payment' } },
                { path: 'table-schedule/:id?', name: 'TableSchedule', component: TableSchedule, props: true, meta: { title: 'TableSchedule' } },
                { path: 'client-payment', name: 'ClientPayment', component: ClientPayment, props: true, meta: { title: 'ClientPayment' } },
                { path: 'co-received', name: 'CoReceived', component: CoReceived, props: true, meta: { title: 'CoReceived' } },
                { path: 'cashier-received', name: 'CashierReceived', component: CashierReceived, props: true, meta: { title: 'CashierReceived' } },
                { path: 'co-report', name: 'CoReport', component: CoReport, props: true, meta: { title: 'CoReport' } },
                { path: 'daily-report', name: 'DailyReport', component: DailyReport, props: true, meta: { title: 'DailyReport' } },
                { path: 'saving-report', name: 'SavingReport', component: SavingReport, props: true, meta: { title: 'SavingReport' } },
                { path: 'collection-report', name: 'CollectionReport', component: CollectionReport, props: true, meta: { title: 'CollectionReport' } },
                { path: 'collected-report', name: 'CollectedReport', component: CollectedReport, props: true, meta: { title: 'CollectedReport' } },
                { path: 'completed-report', name: 'CompletedReport', component: CompletedReport, props: true, meta: { title: 'CompletedReport' } },
                { path: 'borrowed-report', name: 'BorrowedReport', component: BorrowedReport, props: true, meta: { title: 'BorrowedReport' } },
                { path: 'late-report', name: 'LateReport', component: LateReport, props: true, meta: { title: 'LateReport' } },
                { path: 'list-approve', name: 'ListApprove', component: ListApprove, props: true, meta: { title: 'ListApprove' } },
                { path: 'closing-report', name: 'GetClosingReport', component: GetClosingReport, props: true, meta: { title: 'GetClosingReport' } },
                { path: 'summary-co-report', name: 'SummaryCoReport', component: SummaryCoReport, props: true, meta: { title: 'SummaryCoReport' } },
                { path: 'get-logactivity', name: 'GetLogactivity', component: GetLogactivity, props: true, meta: { title: 'GetLogactivity' } },
                { path: 'holiday', name: 'Holiday', component: Holiday, props: true, meta: { title: 'Holiday' } },
                { path: 'holiday-create', name: 'HolidayCreate', component: HolidayCreate, props: true, meta: { title: 'HolidayCreate' } },
                { path: 'history-payment/:id?', name: 'HistoryPayment', component: HistoryPayment, props: true, meta: { title: 'HistoryPayment' } },
                { path: 'collateral-list', name: 'CollateralList', component: CollateralList, props: true, meta: { title: 'CollateralList' } },
                { path: 'overdue-report', name: 'OverdueReport', component: OverdueReport, props: true, meta: { title: 'OverdueReport' } },

                { path: 'contract-day', name: 'ContractDay', component: ContractDay, props: true, meta: { title: 'ContractDay' } },
                { path: 'contract-week', name: 'ContractWeek', component: ContractWeek, props: true, meta: { title: 'ContractWeek' } },
                { path: 'contract-month', name: 'ContractMonth', component: ContractMonth, props: true, meta: { title: 'ContractMonth' } },
                { path: 'permissions', name: 'permissionTest', component: permissionTest, meta: { title: 'permissionTest' } },
                { path: 'collateral-detail-create/:id?', name: 'CollateralDetailCreate', component: CollateralDetailCreate, props: true, meta: { title: 'CollateralDetailCreate' } },
                { path: 'collateral-report', name: 'CollateralListReport', component: CollateralListReport, props: true, meta: { title: 'CollateralListReport' } },
                { path: 'group', name: 'Group', component: Group, props: true, meta: { title: 'Group' } },
                {
                    path: "payment-notyet-closing-report",
                    name: "PaymentNotClosingReport",
                    component: PaymentNotClosingReport,
                    meta: { title: "PaymentNotClosingReport" },
                },
                 {
                    path: "loan-not-closing-report",
                    name: "LoanNotClosingReport",
                    component: LoanNotClosingReport,
                    meta: { title: "LoanNotClosingReport" },
                },
            ]
        },
        ////////////////////////////// Account ///////////////////////////////
        /////////////////////////////////////////////////////////////////////
        {
            path: '/accounting',
            component: Index,
            children: [
                ////////////////////////////// Accounting ///////////////////////////////
                ////////////////////////////////////////////////////////////////////////
                { path: 'type-of-account', name: 'TypeOfAccountList', component: TypeOfAccountList, meta: { title: 'TypeOfAccountList' } },
                { path: 'chart-of-account', name: 'ChartOfAccountList', component: ChartOfAccountList, meta: { title: 'ChartOfAccountList' } },

                ////////////////////////////// Accountant ///////////////////////////////
                ////////////////////////////////////////////////////////////////////////
                { path: 'assets', name: 'AssetList', component: AssetList, meta: { title: 'AssetList' } },
                { path: 'depreciation', name: 'DepreciationList', component: DepreciationList, meta: { title: 'DepreciationList' } },
                { path: 'print-schedule/:id?', name: 'PrintSchedule', component: PrintSchedule, props: true, meta: { title: 'Print Schedule' } },
                { path: 'monthly-depreciation', name: 'MonthlyDepreciation', component: MonthlyDepreciation, meta: { title: 'MonthlyDepreciation' } },
                // { path: 'account-payable', name: 'AccountPayable', component: AccountPayable, meta: { title: 'AccountPayable' } },
                { path: 'journals', name: 'JournalList', component: JournalList, meta: { title: 'JournalList' } },

                ////////////////////////////// Financial Report ///////////////////////////////
                //////////////////////////////////////////////////////////////////////////////
                { path: 'journals-report', name: 'JournalReport', component: JournalReport, meta: { title: 'JournalReport' } },
                { path: 'cash-flow', name: 'CashFlow', component: CashFlow, meta: { title: 'CashFlow' } },
                { path: 'balance-sheet', name: 'BalanceSheet', component: BalanceSheet, meta: { title: 'BalanceSheet' } },
                { path: 'net-profit-and-loss', name: 'NetProfitAndLoss', component: NetProfitAndLoss, meta: { title: 'NetProfitAndLoss' } },
                { path: 'general-ledger', name: 'GeneralLedger', component: GeneralLedger, meta: { title: 'GeneralLedger' } },
                { path: 'trial-balance', name: 'TrialBalance', component: TrialBalance, meta: { title: 'TrialBalance' } },

                { path: 'expense-list', name: 'ExpenseList', component: ExpenseList, props: true, meta: { title: 'ExpenseList' } },
                { path: 'expense-report', name: 'ExpenseReport', component: ExpenseReport, props: true, meta: { title: 'ExpenseReport' } },
                { path: 'income-list', name: 'IncomeList', component: IncomeList, props: true, meta: { title: 'IncomeList' } },
                { path: 'income-report', name: 'IncomeReport', component: IncomeReport, props: true, meta: { title: 'IncomeReport' } },
            ]
        },
        ////////////////////////////// END Account ///////////////////////////////
        /////////////////////////////////////////////////////////////////////


    ],
});
router.afterEach((to, from) => {
    Vue.nextTick(() => {
        document.title = to.meta.title ? to.meta.title : 'LOAN SYSTEM';
    });
})
