<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Scripts -->
    <link rel="icon" href="{{ asset('/images/logo.png') }}">
    <!-- Latest compiled and minified CSS -->
    <link href="{{ asset('css/fontsawesome/all.css') }}" rel="stylesheet">
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>
</head>

<body style="visibility: hidden">
    <div class="main admin_menu">
        <div class="d_header bg-white">
            <div class="row mx-0 px-2 pyt_5 align-mid align-items-center">
                <div class="mr-auto">
                    <button type="button" class="btn btn-md btn-white border-0 btn_navbar_toggle" onclick="navbarToggle()"
                        id="btn_navbar_toggle">
                        <i class="fa-solid fa-bars f_size_18"></i>
                    </button>
                </div>
                <ul class="d-flex">
                    <li class="nav-item dropdown mr-2 bg-white">
                        <a class="nav-link text-dark" href="{{ route('lock') }}">
                            <i class="cus_icon fa-solid fa-lock"></i>
                            Lock
                        </a>

                    </li>
                </ul>
            </div>
            <div onmouseover="showNavbar()" onmouseleave="hideNavbar()"
                class="navbar_left vh-100 bg-white shadow-sm position-fixed z_index_99"
                style="border-right: 0.2px solid #f5f5f5;">
                <div class="d-flex align-items-center p-1 logo mt-3">
                    {{-- <img src="images/logo.png" alt="" width="40px" /> --}}
                    <p class="h5 col ml-2 mb-0 p-0 nd_none"><b>System Admin</b></p>
                </div>
                <div class="accordion pt-4" id="action_collapse">
                    <div class="{{ request()->is('system-admin') ? 'position-relative router-link-exact-active' : 'position-relative' }}">
                        <a href="{{ route('systemAdmin') }}" class="d-flex justify-content-between h_collapse ml_list position-relative">
                            <div class="d-flex align-items-center h_collapse btn_collapse btn_collapse_white">
                                <i class="cus_icon fa-solid fa-lock fa-lg text-secondary f_size_16"></i>
                                <span class="nd_none nowrap">Sync Role</span>
                            </div>
                        </a>
                    </div>
                    <div class="{{ request()->is('system-admin/terminal') ? 'position-relative router-link-exact-active' : 'position-relative' }}">
                        <a href="{{ url('system-admin/terminal') }}" class="d-flex justify-content-between h_collapse ml_list position-relative">
                            <div class="d-flex align-items-center h_collapse btn_collapse btn_collapse_white">
                                <i class="cus_icon fa-solid fa-terminal fa-lg text-secondary f_size_16"></i>
                                <span class="nd_none nowrap">Terminal</span>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

        </div>
        <div class="d_content overflow-auto">
            @yield('content')
        </div>
    </div>

</body>
@yield('script')
<script type="text/javascript">
    $(document).ready(function() {

        function greet() {
            $("body").css("visibility", 'visible');
        }
        setTimeout(greet, 300);

        $(".btn_collapse_toggle").click(function() {
            $(this).find('.collapse_toggle').toggleClass('hide_cn');
        });
        // check scrren
        var $window = $(window);

        function checkWidth() {
            var windowsize = $window.width();
            if (windowsize < 820) {
                $('body').addClass('is_hide_navbar');
            } else {
                $('body').removeClass('is_hide_navbar');
            }
        }
        checkWidth();
        $(window).resize(checkWidth);


    });

    function hideNavbar() {
        $("body").removeClass("o_hide_navbar");
    }

    function showNavbar() {
        $("body").addClass("o_hide_navbar");
    }

    function navbarToggle() {
        $("body").toggleClass("is_hide_navbar");
    }
</script>


</html>
