@extends('admin-system.admin')
@section('content')
<div class="container-fluid px-0">
    <div class="row">
        <div class="col-sm-12">
            <div class="card border-0 bg-transparent">
                <div class="card-header border-0 bg-transparent px-0 py-0 mb_16">
                    <div class="d-flex justify-content-between">
                        <a class="page-title text-nowrap">
                            <h5 class="text-koulen text-secondary">Sync Role</h5>
                        </a>
                    </div>
                </div>
                <div class="card-body p-3 border-0 bg-white rounded-lg">
                    <div class="mb-3">
                        <form action="{{ route('syncRole') }}" method="post" class="row">
                            @csrf
                            <div class="col-sm-5 form-group">
                                <label for="">User<sup class="text-danger">*</sup></label>
                                <select name="user_id" class="form-control @error('user_id') is-invalid @enderror">
                                    <option value="">Select User</option>
                                    @foreach ($users as $val )
                                        <option value="{{ $val->id }}">{{ $val->name }}</option>
                                    @endforeach
                                </select>

                            </div>
                            <div class="col-sm-5 form-group">
                                <label for="">Role<sup class="text-danger">*</sup></label>
                                <select name="role_id" class="form-control @error('role_id') is-invalid @enderror">
                                    <option value="">Select Role</option>
                                    @foreach ($roles as $val )
                                        <option value="{{ $val->id }}">{{ $val->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-sm-2 form-group">
                                <label for="">.</label>
                                <button type="submit" class="btn btn-success form-control">Save</button>
                            </div>
                        </form>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-borderless mb-0">
                            <thead>
                                <tr class="border-top border-bottom text-nowrap">
                                    <th>#</th>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Contact Number</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $key => $value)
                                <tr>
                                    <td>{{ $key+1 }}</td>
                                    <td>{{ $value->code }}</td>
                                    <td>{{ $value->name }}</td>
                                    <td>{{ $value->contact_number }}</td>
                                    <td>{{ $value->email }}</td>
                                    <td>{{ $value->roles->first()->name??'' }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')

@endsection
