<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{asset('/images/logo.png')}}">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="{{ asset('css/fontsawesome/all.css') }}" rel="stylesheet">
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body>

<div class="wrap-login">
    <div class="header-login pl-5">
        <span class="h4">ប្រព័ន្ធគ្រប់គ្រង<span>ប្រាក់កម្ចី</span> <span>សម្រាប់សហគ្រាសធុនតូច និងមធ្យម</span></span>
    </div>
    <div class="d-flex justify-content-center align-items-center">
        <div class="body-login">
            <div class="box-img">
                <img src="{{asset('images/logo.png')}}" />
            </div>
            <div class="w-100">
                <form method="POST" action="{{ route('login') }}" class="px-3 py-4">
                    @csrf
                    <div class="input-group col-12 mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fa fa-user"></i></span>
                        </div>
                        <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}"  autofocus>
                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="input-group col-12 mb-3">
                        <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fa fa-lock"></i></span>
                        </div>
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">
                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="form-group col-12 mb-0">
                        <button type="submit" class="outline-success btn btn-success input-block-level form-control">
                            <i class="fa fa-power-off"></i> ចូល
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <a class="footer-login d-flex fixed-bottom mb-0 justify-content-end align-items-center pr-5" href="https://t.me/Somnab" target="_blank">
        <p>Telegram Service</p>
        <i class="fa-brands fa-telegram fa-2x  pl-2"></i>
    </a>
</div>


</body>
</html>
