<?php

use App\Models\Currency;
use App\Helpers\CustomDateFilter;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\Admin\CoController;
use App\Http\Controllers\Admin\LoanController;
use App\Http\Controllers\Admin\GroupController;
use App\Http\Controllers\System\RoleController;
use App\Http\Controllers\System\UserController;
use App\Http\Controllers\Admin\BranchController;
use App\Http\Controllers\Admin\ClientController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\SavingController;
use App\Http\Controllers\System\AdminController;
use App\Http\Controllers\Admin\CompanyController;
use App\Http\Controllers\Admin\HolidayController;
use App\Http\Controllers\System\BackupController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CurrencyController;
use App\Http\Controllers\System\SettingController;
use App\Http\Controllers\Admin\ComponentController;
use App\Http\Controllers\Admin\CollateralController;
use App\Http\Controllers\System\DashboardController;
use App\Http\Controllers\Admin\ScheduleRunController;
use App\Http\Controllers\Admin\ClientPaymentController;
use App\Http\Controllers\Admin\Accounting\AssetController;
use App\Http\Controllers\Admin\Accounting\IncomeController;
use App\Http\Controllers\Admin\Accounting\ExpenseController;
use App\Http\Controllers\Admin\Accounting\JournalController;
use App\Http\Controllers\Admin\Accounting\CashFlowController;
use App\Http\Controllers\Admin\Accounting\BalanceSheetController;
use App\Http\Controllers\Admin\Accounting\DepreciationController;
use App\Http\Controllers\Admin\Accounting\TrialBalanceController;
use App\Http\Controllers\Admin\Accounting\GeneralLedgerController;
use App\Http\Controllers\Admin\Accounting\TypeOfAccountController;
use App\Http\Controllers\Admin\Accounting\ChartOfAccountController;
use App\Http\Controllers\Admin\Accounting\NetProfitAndLossController;
use App\Http\Controllers\Admin\Accounting\ComponentAccountingController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//Clear route cache:
Route::get('/route-cache', function() {
  $exitCode = Artisan::call('route:cache');
  return 'Routes cache cleared';
});

//Clear config cache:
Route::get('/config-cache', function() {
  $exitCode = Artisan::call('config:cache');
  return 'Config cache cleared';
});
Route::get('/cache-clear', function() {
  $exitCode = Artisan::call('cache:clear');
  return 'cache cleared';
});
Route::get('/cache-view', function() {
  $exitCode = Artisan::call('view:clear');
  return 'cache cleared';
});
Route::get('/', function () {
      // $postId = 1;
      // $getPost = DB::select(
      //   'CALL get_posts_by_userid('.$postId.')'
      // );
      // dd($getPost);
    return view('layouts.app');
})->middleware(['auth'])->name('dashboard');
Auth::routes();

Route::group(['middleware' => ['system_admin']], function() {
  Route::get('system-admin',[AdminController::class,'index'])->name('systemAdmin');
  Route::get('lock',[AdminController::class,'lock'])->name('lock');
  Route::post('sync-role',[AdminController::class,'syncRole'])->name('syncRole');
});

Route::get('lock-screen',[AdminController::class,'login']);
Route::post('un-lock',[AdminController::class,'unLock'])->name('unLock');

Route::group(['middleware' => ['auth'],'prefix'=>'system'], function() {
    //=================== BackupController =========================//
    //==============================================================//
    Route::get('/backup', [BackupController::class,'index']);
    Route::get('/backup/create', [BackupController::class,'create']);
    Route::get('/download/{file_name}', [BackupController::class,'download']);
    Route::get('/backup/delete/{file_name}', [BackupController::class,'delete']);


    //=================== UserController =========================//
    //===============================================================//
    Route::resource('users',UserController::class);
    Route::get('get-user',[UserController::class,'getUser']);
    Route::POST('update-user-profile/{id}',[UserController::class,'updateProfile']);
    Route::GET('active-action/{id}',[UserController::class,'activeAction']);
    Route::GET('switch-branch/{id}',[UserController::class,'switchBranch']);
    Route::GET('switch-currency/{id}',[UserController::class,'switchCurrency']);

    //=================== SettingController =========================//
    //===============================================================//
    Route::get('/setting', [SettingController::class,'index']);
    Route::POST('/setting', [SettingController::class,'update']);
    Route::get('/check-lang', [SettingController::class,'checkLang']);

    //=================== RoleController =========================//
    //============================================================//
    Route::resource('roles',RoleController::class);
    Route::GET('get-permission/{id}',[RoleController::class,'getPermission']);


    //================= DashboardController =======================//
    //============================================================//
    Route::GET('get-data-dashboard',[DashboardController::class,'getData']);
    Route::GET('get-journal-by-yearly',[DashboardController::class,'getDataJournalByYearly']);


});

Route::group(['middleware' => ['auth'],'prefix'=>'admin-api'], function() {

    //=================== UserController =========================//
    //===============================================================//
    Route::POST('employee',[UserController::class,'employeeStore']);
    Route::POST('emp-attachment/{id}',[UserController::class,'EMPAttachmentStore']);
    Route::GET('get-emp-attachment/{id}',[UserController::class,'getEMPAttachment']);
    Route::DELETE('delete-emp-attachment/{id}',[UserController::class,'deleteEMPAttachment']);
    Route::GET('active-action/{id}',[UserController::class,'activeAction']);
    Route::GET('getLogactivity',[UserController::class,'getLogactivity']);




    //=================== CompanyController =========================//
    //===============================================================//
    Route::resource('company',CompanyController::class);
    Route::get('get-company',[CompanyController::class,'getCompany']);


    Route::GET('/get-keyword-date', function () {
        return CustomDateFilter::getKeywordDate();
    });
    //=================== ComponentController =========================//
    //===============================================================//
    Route::get('get-all-user',[ ComponentController::class,'getAllUser']);
    Route::get('address-autocomplete', [ ComponentController::class,'autoCompleteAddress']);
    Route::get('/get-payment-method', [ ComponentController::class,'getPaymentMethod']);
    Route::get('/get-provinces', [ ComponentController::class,'getProvince']);
    Route::get('/get-districts', [ ComponentController::class,'getDistrict']);
    Route::get('/get-communes', [ ComponentController::class,'getCommune']);
    Route::get('/get-villages', [ ComponentController::class,'getVillage']);
    Route::GET('com-client',[ComponentController::class,'getClient']);
    Route::GET('com-co',[ComponentController::class,'getCO']);
    Route::GET('com-loan-status',[ComponentController::class,'getLoanStatus']);
    Route::GET('com-category',[ComponentController::class,'getCategory']);
    Route::GET('com-collaterals',[ComponentController::class,'getCollateral']);
    Route::GET('com-user',[ComponentController::class,'getUser']);
    Route::GET('default-currency',[ComponentController::class,'getDefaultCurrency']);
    //=================== ClientController =========================//
    //===============================================================//
    Route::resource('clients',ClientController::class);
    //=================== CategoryController =========================//
    //===============================================================//
    Route::resource('categories',CategoryController::class);
    //=================== CollateralController =========================//
    //===============================================================//
    Route::resource('collaterals',CollateralController::class);
    Route::GET('collateral-list',[CollateralController::class,'getCollateralDetail']);
    Route::GET('collateral-report',[CollateralController::class,'getCollateralReport']);
    Route::GET('create-detail',[CollateralController::class,'getCollateralDetailCreate']);
    Route::POST('store-detail',[CollateralController::class,'storeCollateralDetailCreate']);
    //=================== CoController =========================//
    //===============================================================//
    Route::resource('coes',CoController::class);
    //=================== BranchController =========================//
    //===============================================================//
    Route::resource('branches',BranchController::class);
    //===================CurrencyController =========================//
    //===============================================================//
    Route::resource('currency',CurrencyController::class);
    //===================LoanController =========================//
    //===============================================================//
    Route::resource('loans',LoanController::class);
    Route::get('loans/show-payment/{id}',[LoanController::class,'ShowPayment']);
    Route::get('loans/get-payment/{id}',[LoanController::class,'GetPayment']);
    Route::get('getLoanPayment',[LoanController::class,'getLoanPayment']);
    Route::get('list-approve',[LoanController::class,'getListApprove']);
    Route::get('contract-day/{id}',[LoanController::class,'getContractDay']);
    Route::post('loan-reschedule',[LoanController::class,'storeReschedule']);
    Route::post('move-co',[LoanController::class,'MoveCo']);
    Route::get('overdue-report',[LoanController::class,'OverdueReport']);
    Route::PUT('move-to-write-off/{id}',[LoanController::class,'moveToWriteOff']);

    // Route::get('schedule-loan-write-off',[ScheduleRunController::class,'AutoUpdateLoanToWriteOff']);

    //===================ClientPaymentController =========================//
    //===============================================================//
    Route::resource('client-payment',ClientPaymentController::class);
    Route::get('daily-payment',[ClientPaymentController::class,'DailyPayment']);
    Route::post('cashier-approve',[ClientPaymentController::class,'Approve']);
    Route::post('submit-closing-report',[ClientPaymentController::class,'ClosingReport']);
    Route::get('notifications',[ClientPaymentController::class,'Notification']);
    Route::get('show-pay-all/{id}',[ClientPaymentController::class,'ShowPayAll']);
    Route::post('submit-pay-all',[ClientPaymentController::class,'SubmitPayAll']);
    Route::PUT('admin-back-payment/{id}',[ClientPaymentController::class,'adminBackPayment']);
    //===================Report =========================//
    //===============================================================//
    Route::Get('co-report',[ReportController::class,'CoReport']);
    Route::Get('daily-report',[ReportController::class,'DailyReport']);
    Route::Get('late-report',[ReportController::class,'LateReport']);
    Route::Get('collection-report',[ReportController::class,'CollectionReport']);
    Route::Get('collected-report',[ReportController::class,'CollectedReport']);
    Route::Get('completed-report',[ReportController::class,'CompletedReport']);
    Route::Get('borrowed-report',[ReportController::class,'BorrowedReport']);
    Route::Get('summary-co-report',[ReportController::class,'SummaryCoReport']);
    Route::GET('user-permissions',[UserController::class,'getUserPermission']);
    Route::resource('holidays',HolidayController::class);
    Route::GET('com-holidays',[HolidayController::class,'comHoliday']);

    Route::get('payment-not-closing-report',[ReportController::class,'paymentNotClosingReport']);
    Route::get('loan-not-closing-report',[ReportController::class,'loanNotClosingReport']);

    //===================Report =========================//
    //===============================================================//
    Route::Get('ExportCollected',[ReportController::class,'ExportCollected']);
    Route::Get('ExportCollection',[ReportController::class,'ExportCollection']);
    Route::Get('ExportCompleted',[ReportController::class,'ExportCompleted']);
    Route::Get('ExportBorrow',[ReportController::class,'ExportBorrow']);
    Route::Get('ExportDaily',[ReportController::class,'ExportDaily']);
    Route::Get('ExportLate',[ReportController::class,'ExportLate']);
    Route::Get('ExportSummaryCo',[ReportController::class,'ExportSummaryCo']);
    Route::Get('ExportCo',[ReportController::class,'ExportCo']);
    Route::Get('ExportCollateral',[CollateralController::class,'ExportCollateral']);

    Route::Get('ExportLoan',[ReportController::class,'ExportLoan']);

    //===================Expense =========================//
    //===============================================================//



    //=================== SavingController =========================//
    //===============================================================//
    Route::resource('saving',SavingController::class);
    Route::POST('request-saving',[SavingController::class,'requestSaving']);
    Route::POST('approve-saving',[SavingController::class,'approveSaving']);

    //===================GroupController =========================//
    //===============================================================//
    Route::resource('groups',GroupController::class);

  });

Route::group(['middleware' => ['auth'],'prefix'=>'accounting'], function() {




    //=================== TypeOfAccountController =========================//
    //====================================================================//
    Route::resource('type-of-account',TypeOfAccountController::class);

    //=================== ChartOfAccountController =========================//
    //====================================================================//
    Route::resource('chart-of-account',ChartOfAccountController::class);

    //========================= AssetController ==========================//
    //====================================================================//
    Route::resource('assets',AssetController::class);

    //========================= JournalController =========================//
    //====================================================================//
    Route::resource('journals',JournalController::class);
    //========================= ExpenseController =========================//
    //====================================================================//
    Route::resource('expenses',ExpenseController::class);
    //========================= IncomeController =========================//
    //====================================================================//
    Route::resource('incomes',IncomeController::class);

    //=================== CashFlowController =========================//////
    //====================================================================//
    Route::GET('cash-flow',[CashFlowController::class,'getCashFlow']);

    //=================== BalanceSheetController =========================//
    //====================================================================//
    Route::GET('balance-sheet',[BalanceSheetController::class,'balanceSheet']);

    //=================== NetProfitAndLossController =====================//////
    //====================================================================/////
    Route::GET('netprofit-loss',[NetProfitAndLossController::class,'getProfitLoss']);

    //====================== GeneralLedgerController =====================//////
    //====================================================================/////
    Route::GET('general-ledger',[GeneralLedgerController::class,'getGeneralLedger']);

    //====================== TrialBalanceController =====================//////
    //====================================================================/////
    Route::GET('trial-balance',[TrialBalanceController::class,'getTrialBalance']);

    //====================== DepreciationController =====================//////
    //====================================================================/////
    Route::resource('depreciation',DepreciationController::class);
    Route::POST('submit-payment-depreciation/{id}',[DepreciationController::class,'submitPaymentDepreciation']);
    Route::GET('monthly-depreciation',[DepreciationController::class,'getMonthlyDepreciation']);
    Route::POST('submit-all-payment-depreciation',[DepreciationController::class,'submitAllPaymentDepreciation']);


    //=================== ComponentAccountingController ==================//////
    //====================================================================/////
    Route::GET('get-type-acc',[ComponentAccountingController::class,'getTypeAccount']);
    Route::GET('get-type-of-acc-details/{id}',[ComponentAccountingController::class,'getTypeAccDetails']);
    Route::GET('com-chart-of-account',[ComponentAccountingController::class,'getChartOfAccount']);
    Route::GET('get-current-asset',[ComponentAccountingController::class,'getChartOfAccCurrentAsset']);
    Route::GET('get-asset',[ComponentAccountingController::class,'getAssets']);
    Route::GET('get-acc-fixed-asset',[ComponentAccountingController::class,'getAccFixedAsset']);
    Route::GET('get-acc-expense',[ComponentAccountingController::class,'getAccExpense']);
    Route::GET('com-cash-bank',[ComponentAccountingController::class,'getCashBank']);
    Route::GET('com-expense',[ComponentAccountingController::class,'getExpense']);
    Route::GET('com-income',[ComponentAccountingController::class,'getIncome']);


});
